/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.prob.SampleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import nuts.util.Counter;
import nuts.util.MathUtils;

public class ProposalRandom {
    public double logProbability = 0.0;
    public final Random rand;

    public double getLogProbability() {
        return this.logProbability;
    }

    public ProposalRandom(Random rand) {
        this.rand = rand;
    }

    public <S> S sampleMultinomial(Counter<S> counter) {
        S item = Sampling.sampleCounter(counter, this.rand);
        this.logProbability += Math.log(counter.getCount(item));
        return item;
    }

    public int sampleDiscreteUniform(int n) {
        this.logProbability -= Math.log(n);
        return this.rand.nextInt(n);
    }

    public boolean sampleBern(double p) {
        double u = this.rand.nextDouble();
        if (u < p) {
            this.logProbability += Math.log(p);
            return true;
        }
        this.logProbability += Math.log(1.0 - p);
        return false;
    }

    public int sampleMultinomial(double[] ps) {
        int index = SampleUtils.sampleMultinomial(this.rand, ps);
        this.logProbability += Math.log(ps[index]);
        return index;
    }

    public double sampleUniform(double len) {
        this.logProbability -= Math.log(len);
        return len * this.rand.nextDouble();
    }

    public List<Double> samplePartitions(int numberOfPartitions, double len) {
        ArrayList<Double> pts = new ArrayList<Double>();
        pts.add(0.0);
        for (int i = 0; i < numberOfPartitions; ++i) {
            pts.add(this.sampleUniform(len));
        }
        pts.add(len);
        Collections.sort(pts);
        if (numberOfPartitions > 0) {
            this.logProbability += MathUtils.logFactorial(numberOfPartitions - 1);
        }
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 1; i < pts.size(); ++i) {
            result.add((Double)pts.get(i) - (Double)pts.get(i - 1));
        }
        return result;
    }
}

