/*
 * Decompiled with CFR 0.152.
 */
package nuts.tools;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.util.CollUtils;

public class TransformLatex
implements Runnable {
    @Option
    public String prefix = "arxiv";
    @Option
    public File folder = new File("/Users/bouchard/papers/mbe2011-poisson-paper");
    @Option
    public String mainFileRelativePath = "pnas-version.tex";

    public static void main(String[] args) {
        IO.run(args, new TransformLatex());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void var8_13;
        void var8_11;
        String cmd;
        File destFolder = new File(Execution.getFile("output"));
        destFolder.mkdir();
        File mainFile = new File(this.folder, this.mainFileRelativePath);
        ArrayList<String> mainFileContents = new ArrayList<String>();
        String figCue = null;
        String figKey = null;
        HashMap figs = new HashMap();
        LogInfo.track("Applying macros to " + mainFile);
        for (String string : IO.i(mainFile)) {
            String[] stringArray = this.readCommand(string);
            String linePrefix = string.replaceAll(this.prefix + ".*", "");
            if (stringArray == null) {
                if (figCue != null) {
                    List current = (List)figs.get(figKey);
                    current.add(string);
                    if (!string.contains(figCue)) continue;
                    figCue = null;
                    figKey = null;
                    continue;
                }
                mainFileContents.add(string);
                continue;
            }
            cmd = stringArray[0];
            if (cmd.equals("rem")) continue;
            if (cmd.equals("add")) {
                String cur = "";
                for (int i2 = 1; i2 < stringArray.length; ++i2) {
                    cur = cur + stringArray[i2] + " ";
                }
                if (figCue == null) {
                    mainFileContents.add(cur);
                    continue;
                }
                ((List)figs.get(figKey)).add(cur);
                continue;
            }
            if (cmd.equals("include")) {
                mainFileContents.add(linePrefix);
                File toMove = new File(this.folder, stringArray[1]);
                if (!toMove.exists()) {
                    throw new RuntimeException();
                }
                File dest = this.ensureEnclosingFolderExists(new File(destFolder, stringArray[1]));
                IO.call("cp " + toMove.getAbsolutePath() + " " + dest.getAbsolutePath());
                LogInfo.logsForce("adding " + stringArray[1]);
                continue;
            }
            if (cmd.equals("figtarget")) {
                mainFileContents.add(string);
                continue;
            }
            if (cmd.equals("movefig")) {
                if (figKey != null) {
                    throw new RuntimeException();
                }
                figKey = stringArray[1];
                figCue = StringUtils.selectFirstRegex(".*(\\\\begin[{][^}]+[}]).*", string).replaceAll("begin", "end");
                List current = CollUtils.getNoNullList(figs, figKey);
                current.add(linePrefix.replaceAll("\\[h[!]\\]", "[t!]"));
                continue;
            }
            throw new RuntimeException();
        }
        LogInfo.end_track();
        ArrayList<String> finalContents = new ArrayList<String>();
        for (String string : mainFileContents) {
            String[] readCommand = this.readCommand(string);
            if (readCommand == null) {
                finalContents.add(string.replaceAll("\\\\citep", "\\\\cite"));
                continue;
            }
            cmd = readCommand[0];
            if (cmd.equals("figtarget")) {
                List contents = (List)figs.get(readCommand[1]);
                if (contents == null) {
                    throw new RuntimeException();
                }
                for (String s : contents) {
                    finalContents.add(s.replaceAll("figure[*]", "figure").replaceAll("\\\\citep", "\\\\cite"));
                }
                continue;
            }
            throw new RuntimeException();
        }
        this.mainFileRelativePath = this.mainFileRelativePath.replaceAll("pnas", "arxiv");
        IO.writeToDisk(this.ensureEnclosingFolderExists(new File(destFolder, this.mainFileRelativePath)), finalContents);
        LogInfo.track("Running pdflatex, bibtex");
        boolean bl = false;
        while (var8_11 < true) {
            LogInfo.logsForce("pdflatex(" + (int)var8_11 + ")");
            LogInfo.logsForce(IO.call("pdflatex " + this.mainFileRelativePath, "x\n", destFolder));
            ++var8_11;
        }
        LogInfo.logsForce("bibtex");
        LogInfo.logsForce(IO.call("bibtex " + this.mainFileRelativePath.replaceAll("[.]tex", ""), null, destFolder));
        boolean bl2 = false;
        while (var8_13 < 2) {
            LogInfo.logsForce("pdflatex(" + (int)var8_13 + ")");
            LogInfo.logsForce(IO.call("pdflatex " + this.mainFileRelativePath, "x\n", destFolder));
            ++var8_13;
        }
        LogInfo.end_track();
        new File(destFolder, "arxiv-version.aux").delete();
        new File(destFolder, "arxiv-version.blg").delete();
        new File(destFolder, "arxiv-version.log").delete();
        File file = new File(destFolder, "arxiv-version.pdf");
        file.renameTo(new File(Execution.getFile("output.pdf")));
        new File(destFolder, "references.bib").delete();
        IO.call("zip -r " + destFolder.getName() + " " + destFolder.getName(), null, destFolder.getParentFile());
    }

    private File ensureEnclosingFolderExists(File file) {
        if (file.exists()) {
            return file;
        }
        File parent = file.getParentFile();
        this.ensureEnclosingFolderExists(parent);
        parent.mkdir();
        return file;
    }

    private String[] readCommand(String line) {
        if (!line.contains(this.prefix)) {
            return null;
        }
        line = line.replaceAll(".*" + this.prefix + "\\s+", "");
        return line.split("\\s+");
    }
}

