/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import nuts.io.IO;

public class ImageUtils {
    public static void main(String[] args) throws Exception {
        int[][] data = ImageUtils.loadImage(new File("/Users/bouchard/Pictures/scan/011211/Scan011211_171008.jpg"));
        for (int x = 0; x < data.length; ++x) {
            if (x % 2 != 0) continue;
            for (int y = 0; y < data[0].length; ++y) {
                data[x][y] = 0;
            }
        }
        ImageUtils.saveImage(new File("/Users/bouchard/temp/test-copy.jpg"), data);
    }

    public static int[][] loadImage(File f) {
        try {
            BufferedImage img = ImageIO.read(f);
            int H = img.getHeight();
            int W = img.getWidth();
            int[][] result = new int[W][H];
            for (int w = 0; w < W; ++w) {
                for (int h = 0; h < H; ++h) {
                    result[w][h] = img.getRGB(w, h);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveImage(File f, int[][] pixels) {
        int W = pixels.length;
        int H = pixels[0].length;
        BufferedImage img = new BufferedImage(W, H, 1);
        for (int w = 0; w < W; ++w) {
            for (int h = 0; h < H; ++h) {
                img.setRGB(w, h, pixels[w][h]);
            }
        }
        String ext = IO.extension(f).toUpperCase();
        try {
            ImageIO.write((RenderedImage)img, ext, f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

