/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import fig.basic.StrUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import nuts.io.IO;
import nuts.util.CollUtils;

public class RemoteUtils {
    public static void scp(String sourceHost, Collection<String> sourceFiles, File destinationFolder) {
        destinationFolder.mkdir();
        ArrayList processed = CollUtils.list();
        for (String srcFile : sourceFiles) {
            processed.add(sourceHost + ":" + srcFile);
        }
        IO.call("scp -C -r " + StrUtils.join(processed) + " " + destinationFolder.getAbsolutePath());
    }

    public static void fastScp(String sourceHost, String prefix, Collection<String> sourceFiles, File destinationFolder) {
        if (prefix == null || prefix.equals("")) {
            prefix = "~";
        }
        String tempFile = "temp" + System.currentTimeMillis();
        RemoteUtils.remoteBash(sourceHost, "cd " + prefix + ";zip -r " + tempFile + " " + StrUtils.join(sourceFiles, " "));
        String remoteZip = prefix + "/" + tempFile + ".zip";
        RemoteUtils.scp(sourceHost, Arrays.asList(remoteZip), destinationFolder);
        RemoteUtils.remoteBash(sourceHost, "rm " + remoteZip);
        File localZip = new File(destinationFolder, tempFile + ".zip");
        IO.call("unzip -o " + localZip.getAbsolutePath(), null, destinationFolder);
        localZip.delete();
    }

    public static void scp(Collection<File> sourceFiles, String destinationHost, String destinationFolder) {
        String str = "scp -C -r ";
        for (File f : sourceFiles) {
            str = str + f.getAbsolutePath() + " ";
        }
        IO.call(str + destinationHost + ":" + destinationFolder);
    }

    public static void scp(File sourceFile, String destinationHost, String destinationPath) {
        if (destinationHost.equals("localhost")) {
            IO.call("cp -r " + sourceFile.getAbsolutePath() + " " + destinationPath, null, IO.ResultCodeBehavior.RAISE);
        } else {
            IO.call("scp -C -r " + sourceFile.getAbsolutePath() + " " + destinationHost + ":" + destinationPath, null, IO.ResultCodeBehavior.RAISE);
        }
    }

    public static void scpAWS(File sourceFile, String destinationHost, String destinationPath, String keypairPath) {
        IO.call("scp -C -r -i " + keypairPath + " " + sourceFile.getAbsolutePath() + " ec2-user@" + destinationHost + ":" + destinationPath, null, IO.ResultCodeBehavior.RAISE);
    }

    public static String remoteBash(String host, List<String> script) {
        return RemoteUtils.remoteBash(host, StrUtils.join(script, ";\n") + ";");
    }

    public static String remoteBashAWS(String host, List<String> script, String keypairPath) {
        return RemoteUtils.remoteBashAWS(host, StrUtils.join(script, ";\n") + ";", keypairPath);
    }

    public static String remoteBash(String host, String script) {
        if (host.equals("localhost")) {
            return IO.call("bash -s", script);
        }
        return IO.call("ssh " + host + " /bin/bash -s", script);
    }

    public static String remoteBashAWS(String host, String script, String keypairPath) {
        return IO.call("ssh -i " + keypairPath + " ec2-user@" + host, script);
    }

    public static void main(String[] args) {
        File dest = new File("temp");
        RemoteUtils.scp("nestor.westgrid.ca", Arrays.asList("~/evolvere/e/gp176.*"), dest);
        RemoteUtils.remoteBashAWS("ec2-50-18-135-100.us-west-1.compute.amazonaws.com", "pwd", "config/testkeypair.pem");
    }
}

