/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import fig.basic.LogInfo;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Ising {
    public static final int WHITE = 1;
    public static final int BLACK = -1;
    public static final int RANDOM = 0;
    public static final int RED_PATTERN = 0;
    public static final int WHITE_PATTERN = 1;
    public static final int[] CONFIG = new int[]{-1, 1};
    public int[][] model;
    public int[][] posterior;
    private int numIter = 0;
    private int l;
    private int t = 0;
    private double alpha;
    private double beta;
    private Random random;

    public Ising(int l, double alpha, double T, int config) {
        this.model = new int[l][l];
        this.posterior = new int[l][l];
        this.l = l;
        this.alpha = alpha;
        this.beta = 1.0 / T;
        this.random = new Random();
        if (config == 0) {
            this.randomConfig();
        } else {
            this.setConfig(config);
        }
    }

    public void setConfig(int config) {
        for (int r = 0; r < this.l; ++r) {
            for (int c = 0; c < this.l; ++c) {
                this.model[r][c] = config;
            }
        }
    }

    public void randomConfig() {
        for (int r = 0; r < this.l; ++r) {
            for (int c = 0; c < this.l; ++c) {
                int index = this.random.nextInt(2);
                this.model[r][c] = CONFIG[index];
                this.posterior[r][c] = 0;
            }
        }
    }

    public List<Pair<Integer, Integer>> neighbors(int r, int c) {
        ArrayList<Pair<Integer, Integer>> nbhrs = new ArrayList<Pair<Integer, Integer>>();
        int c1 = c + 1;
        int c2 = c - 1;
        int r1 = r + 1;
        int r2 = r - 1;
        if (c + 1 >= this.l) {
            c1 = 0;
        }
        if (c - 1 < 0) {
            c2 = this.l - 1;
        }
        if (r + 1 >= this.l) {
            r1 = 0;
        }
        if (r - 1 < 0) {
            r2 = this.l - 1;
        }
        Pair<Integer, Integer> p1 = new Pair<Integer, Integer>(r, c1);
        Pair<Integer, Integer> p2 = new Pair<Integer, Integer>(r, c2);
        Pair<Integer, Integer> p3 = new Pair<Integer, Integer>(r1, c);
        Pair<Integer, Integer> p4 = new Pair<Integer, Integer>(r2, c);
        nbhrs.add(p1);
        nbhrs.add(p2);
        nbhrs.add(p3);
        nbhrs.add(p4);
        return nbhrs;
    }

    public int getState(int r, int c) {
        return this.model[r][c];
    }

    public void setState(int c, int r, int s) {
        this.model[c][r] = s;
    }

    public double getT1() {
        int sum = 0;
        for (int r = 0; r < this.l; ++r) {
            for (int c = 0; c < this.l; ++c) {
                sum += this.model[r][c];
            }
        }
        return this.alpha * (double)sum;
    }

    public double getT2() {
        int sum = 0;
        for (int r = 0; r < this.l; ++r) {
            for (int c = 0; c < this.l; ++c) {
                for (Pair<Integer, Integer> n : this.neighbors(r, c)) {
                    int nr = n.getFirst();
                    int nc = n.getSecond();
                    if (nr >= r && nc >= c) continue;
                    sum += this.model[r][c] * this.model[nr][nc];
                }
            }
        }
        return this.beta * (double)sum;
    }

    public double energy() {
        double energy = this.getT1() + this.getT2();
        return energy;
    }

    public void setTemperature(double T) {
        this.beta = 1.0 / T;
    }

    public int countSpins() {
        int sum = 0;
        for (int r = 0; r < this.l; ++r) {
            for (int c = 0; c < this.l; ++c) {
                sum += this.model[r][c];
            }
        }
        return sum;
    }

    public void parallelStepGeyer() {
        int r = this.random.nextInt(this.l);
        int c = this.random.nextInt(this.l);
        double ni = 0.0;
        for (Pair<Integer, Integer> n : this.neighbors(r, c)) {
            int nr = n.getFirst();
            int nc = n.getSecond();
            ni += (double)this.model[nr][nc];
        }
        double logit = Math.exp(2.0 * (this.alpha + this.beta * ni));
        double p = logit / (1.0 + logit);
        double u = this.random.nextDouble();
        this.model[r][c] = u < p ? 1 : -1;
        this.update();
        ++this.numIter;
    }

    private double nhbrs(int r, int c) {
        double ni = 0.0;
        for (Pair<Integer, Integer> n : this.neighbors(r, c)) {
            int nr = n.getFirst();
            int nc = n.getSecond();
            ni += (double)this.model[nr][nc];
        }
        return ni;
    }

    public Pair<Double, Double> gibbsKernel(Random rand) {
        int r = rand.nextInt(this.l);
        int c = rand.nextInt(this.l);
        int old_config = this.model[r][c];
        Pair<Double, Double> retval = new Pair<Double, Double>(0.0, 0.0);
        double new_ni = this.nhbrs(r, c);
        double new_p0 = Math.exp(-this.alpha + -this.beta * new_ni);
        double new_p1 = Math.exp(this.alpha + this.beta * new_ni);
        double z = new_p0 + new_p1;
        double norm_p1 = new_p1 / z;
        double u = rand.nextDouble();
        if (u < norm_p1) {
            this.model[r][c] = 1;
            retval.setFirst(new_p1);
        } else {
            this.model[r][c] = -1;
            retval.setFirst(new_p0);
        }
        this.update();
        ++this.numIter;
        double old_ni = this.nhbrs(r, c);
        double old_p0 = Math.exp(-this.alpha + -this.beta * old_ni);
        double old_p1 = Math.exp(this.alpha + this.beta * old_ni);
        if (old_config == -1) {
            retval.setSecond(old_p0);
        } else {
            retval.setSecond(old_p1);
        }
        return retval;
    }

    public Pair<Double, Double> sample(int r, int c, Random rand) {
        Pair<Double, Double> retval = new Pair<Double, Double>(0.0, 0.0);
        int oldConfig = this.model[r][c];
        double new_ni = this.nhbrs(r, c);
        double new_p0 = Math.exp(-this.alpha + -this.beta * new_ni);
        double new_p1 = Math.exp(this.alpha + this.beta * new_ni);
        double z = new_p0 + new_p1;
        double norm_p1 = new_p1 / z;
        double u = rand.nextDouble();
        if (u < norm_p1) {
            this.model[r][c] = 1;
            retval.setFirst(norm_p1);
        } else {
            this.model[r][c] = -1;
            retval.setFirst(1.0 - norm_p1);
        }
        double old_ni = this.nhbrs(r, c);
        double old_p0 = Math.exp(-this.alpha + -this.beta * old_ni);
        double old_p1 = Math.exp(this.alpha + this.beta * old_ni);
        z = old_p0 + old_p1;
        double norm_old_p1 = old_p1 / z;
        if (oldConfig == -1) {
            retval.setSecond(1.0 - norm_old_p1);
        } else {
            retval.setSecond(norm_old_p1);
        }
        return retval;
    }

    public Pair<Double, Double> checkerboardKernel(Random rand) {
        Pair<Double, Double> retval = new Pair<Double, Double>(0.0, 0.0);
        int pattern = rand.nextInt(2);
        double pOldToNew = 1.0;
        double pNewToOld = 1.0;
        for (int r = 0; r < this.l; ++r) {
            for (int c = 0; c < this.l; ++c) {
                Pair<Double, Double> temp = null;
                if (pattern == 1) {
                    if (r % 2 == 0 && c % 2 == 0) {
                        temp = this.sample(r, c, rand);
                    } else if (r % 2 == 1 && c % 2 == 1) {
                        temp = this.sample(r, c, rand);
                    }
                    if (temp == null) continue;
                    pOldToNew *= temp.getFirst().doubleValue();
                    pNewToOld *= temp.getSecond().doubleValue();
                    continue;
                }
                if (r % 2 == 0 && c % 2 == 1) {
                    temp = this.sample(r, c, rand);
                } else if (r % 2 == 1 && c % 2 == 0) {
                    temp = this.sample(r, c, rand);
                }
                if (temp == null) continue;
                pOldToNew *= temp.getFirst().doubleValue();
                pNewToOld *= temp.getSecond().doubleValue();
            }
        }
        retval.setFirst(pOldToNew);
        retval.setSecond(pNewToOld);
        ++this.numIter;
        this.update();
        return retval;
    }

    public Pair<Double, Double> parallelStep() {
        return this.checkerboardKernel(this.random);
    }

    public Pair<Double, Double> parallelStep(Random rand) {
        return this.checkerboardKernel(rand);
    }

    private void update() {
        for (int r = 0; r < this.l; ++r) {
            for (int c = 0; c < this.l; ++c) {
                if (this.model[r][c] != -1) continue;
                int[] nArray = this.posterior[r];
                int n = c;
                nArray[n] = nArray[n] + 1;
            }
        }
    }

    public void print() {
        for (int r = 0; r < this.l; ++r) {
            StringBuffer sb = new StringBuffer();
            for (int c = 0; c < this.l; ++c) {
                sb.append(this.getState(r, c) + " ");
            }
            LogInfo.logs(sb.toString());
        }
    }

    public void printPosterior() {
        double prop = 0.0;
        for (int r = 0; r < this.l; ++r) {
            StringBuffer sb = new StringBuffer();
            for (int c = 0; c < this.l; ++c) {
                prop = (double)this.posterior[r][c] / (double)this.numIter;
                sb.append(prop);
                sb.append(", ");
            }
            LogInfo.logs(sb.toString());
        }
    }

    public static void main(String[] args) {
        int L = 3;
        double alpha = 1.0;
        double beta = 2.0;
        Ising ising = new Ising(L, alpha, beta, 0);
        ising.print();
        System.out.println("T1=" + ising.getT1());
        System.out.println("T2=" + ising.getT2());
    }
}

