/*
 * Decompiled with CFR 0.152.
 */
package pedi.factor;

import fenchel.factor.FactorUtils;
import fenchel.factor.multisites.MSFactorGraph;
import fenchel.factor.multisites.MSMFOptions;
import fenchel.factor.multisites.MSMeasureFacto;
import fenchel.measurefacto.AcyclicDecompositions;
import fig.basic.LogInfo;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import nuts.math.Graph;
import nuts.math.Graphs;
import nuts.util.MathUtils;
import pedi.Individual;
import pedi.Model;
import pedi.factor.PediMeasureFactoOptions;
import pedi.factor.Pedigree2FactorGraph;
import pedi.factor.PedigreeNode;

public class PediMeasureFacto {
    public static MSMeasureFacto<PedigreeNode> createMeasureFacto(Model model, MSMFOptions fenchelOptions, PediMeasureFactoOptions pediFactoOptions) {
        MSFactorGraph<PedigreeNode> fullFactorGraph = PediMeasureFacto.pedigreeFactorGraph(model);
        Set<PedigreeNode> basicRichNodes = pediFactoOptions.getRichStatsNodes(fullFactorGraph.getTopology().vertexSet());
        if (!model.options.useIndepMarkers()) {
            basicRichNodes.addAll(Pedigree2FactorGraph.getAllNodesOfType(PedigreeNode.PedigreeNodeType.RECOMB, fullFactorGraph.getTopology().vertexSet()));
        }
        if (model.hasDiseaseMarkers()) {
            for (int j = 0; j < model.diseasePhenotypes.diseaseType.nDiseaseNodes(); ++j) {
                basicRichNodes.add(PedigreeNode.createDiseaseNode(j));
            }
            basicRichNodes.addAll(Pedigree2FactorGraph.getAllNodesOfType(PedigreeNode.PedigreeNodeType.ALLELE, fullFactorGraph.getTopology().vertexSet()));
        }
        Set<PedigreeNode> queries = Pedigree2FactorGraph.getAllNodesOfType(PedigreeNode.PedigreeNodeType.HAPLOTYPE, fullFactorGraph.getTopology().vertexSet());
        if (model.hasDiseaseMarkers()) {
            for (int j = 0; j < model.diseasePhenotypes.diseaseType.nDiseaseNodes(); ++j) {
                queries.add(PedigreeNode.createDiseaseNode(j));
            }
        }
        MSMeasureFacto<PedigreeNode> factorization = new MSMeasureFacto<PedigreeNode>(queries, fullFactorGraph, fenchelOptions);
        List subgraphs = PediMeasureFacto.forestCover(pediFactoOptions, fullFactorGraph);
        factorization.addTreeCoverFactors(subgraphs, basicRichNodes, pediFactoOptions.treeAlpha);
        if (!model.options.useIndepMarkers()) {
            Set<PedigreeNode> recombs = Pedigree2FactorGraph.getAllNodesOfType(PedigreeNode.PedigreeNodeType.RECOMB, fullFactorGraph.getTopology().vertexSet());
            factorization.addSingleNodeHMMs(recombs, PediMeasureFacto.recombTrans(model.options.recombRate), pediFactoOptions.recomAlpha);
        }
        if (model.hasDiseaseMarkers()) {
            double diseaseAlpha = pediFactoOptions.diseaseAlpha / (double)model.diseasePhenotypes.phenotypedIndividuals().size();
            for (Individual i : model.diseasePhenotypes.phenotypedIndividuals()) {
                factorization.addPhenotypeHMM(model.diseasePhenotypes.phenotypeInputs(i), model.diseasePhenotypes.getPhenotype(i), diseaseAlpha);
            }
        }
        return factorization;
    }

    private static List<Graph<PedigreeNode>> forestCover(PediMeasureFactoOptions options, MSFactorGraph<PedigreeNode> fullFactorGraph) {
        ArrayList<Graph<PedigreeNode>> subgraphs = new ArrayList<Graph<PedigreeNode>>();
        LinkedList<Graph<PedigreeNode>> queue = new LinkedList<Graph<PedigreeNode>>();
        for (int f = 0; f < options.nFactors; ++f) {
            if (queue.isEmpty()) {
                queue.addAll(AcyclicDecompositions.randomForestCover(fullFactorGraph.getTopology(), options.forestSelectionRand));
            }
            subgraphs.add((Graph<PedigreeNode>)queue.poll());
        }
        PediMeasureFacto.printStatistics(fullFactorGraph.getTopology(), subgraphs);
        return subgraphs;
    }

    private static MSFactorGraph<PedigreeNode> pedigreeFactorGraph(Model model) {
        LogInfo.track((Object)"Creating simplestPedigreeFactorGraph", true);
        MSFactorGraph<PedigreeNode> fg = FactorUtils.newFactorGraph();
        Pedigree2FactorGraph.addGenotypeFactors(model.pedigree, model.data, fg);
        Pedigree2FactorGraph.addInheritanceFactors(model.pedigree, fg, model.data.getFactorEncodings());
        Pedigree2FactorGraph.addSimpleFounderFactors(model.pedigree, model.options.useUniformFounderFreq ? Pedigree2FactorGraph.getUniformHardyWeinbergDistribution(model.data.genomeSize(), model.data.getFactorEncodings(), model.options.uniformAlleleFrequency) : Pedigree2FactorGraph.getEstimatedHardWeinbergDistribution(model.data), fg);
        Pedigree2FactorGraph.addAllelePresenceFactors(model.pedigree, model.data.getFactorEncodings(), fg);
        if (model.hasDiseaseMarkers()) {
            Pedigree2FactorGraph.addDiseaseFactor(model.data.genomeSize(), fg, model.diseasePhenotypes.diseaseType.nDiseaseNodes());
            Pedigree2FactorGraph.addAlleleFactors(model.pedigree, model.data.getFactorEncodings(), fg);
        }
        Pedigree2FactorGraph.check(model.pedigree, fg);
        LogInfo.logs(Pedigree2FactorGraph.summarize(fg.getTopology()));
        LogInfo.end_track();
        return fg;
    }

    public static double[][] recombTrans(double recombRate) {
        if (!MathUtils.isProb(recombRate)) {
            throw new RuntimeException();
        }
        double[][] result = new double[2][2];
        double d = 1.0 - recombRate;
        result[1][1] = d;
        result[0][0] = d;
        double d2 = recombRate;
        result[1][0] = d2;
        result[0][1] = d2;
        return result;
    }

    public static <S> void printStatistics(Graph<S> original, List<Graph<S>> subgraphs) {
        LogInfo.track((Object)"Creating measure factorization", true);
        LogInfo.logs("nEdges(initialGraph)=" + Graphs.edgeSet(original).size());
        LogInfo.track((Object)"Decomposition:", true);
        int factor = 0;
        for (Graph<S> g : subgraphs) {
            LogInfo.logs("nEdges(factor " + factor++ + ")=" + Graphs.edgeSet(g).size());
        }
        LogInfo.end_track();
        LogInfo.end_track();
    }
}

