/*
 * Decompiled with CFR 0.152.
 */
package pedi.factor;

import fig.basic.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import pedi.factor.Pedigree2FactorGraph;
import pedi.factor.PedigreeNode;

public class PediMeasureFactoOptions {
    @Option
    public ArrayList<PedigreeNode.PedigreeNodeType> richStatsTypesForForestCover = new ArrayList<PedigreeNode.PedigreeNodeType>(Arrays.asList(PedigreeNode.PedigreeNodeType.RECOMB, PedigreeNode.PedigreeNodeType.ALLELE_PRESENCE));
    @Option(gloss="Number of factors to use")
    public int nFactors = 2;
    @Option
    public Random forestSelectionRand = new Random(1L);
    @Option
    public double treeAlpha = 0.5;
    @Option
    public double diseaseAlpha = 0.5;
    @Option
    public double recomAlpha = 0.5;

    public Set<PedigreeNode> getRichStatsNodes(Collection<PedigreeNode> allNodes) {
        HashSet<PedigreeNode> richNodes = new HashSet<PedigreeNode>();
        for (PedigreeNode.PedigreeNodeType type : this.richStatsTypesForForestCover) {
            richNodes.addAll(Pedigree2FactorGraph.getAllNodesOfType(type, allNodes));
        }
        return richNodes;
    }
}

