/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.Pair;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.math.Indicator;
import nuts.math.MCIntegrator;
import nuts.math.Sampler;
import nuts.util.Counter;
import pepper.Edit;
import pepper.Encodings;

public class EditParam
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final Encodings enc;
    private double[][][] deletionCosts;
    private double[][][][] substitutionCosts;
    private double[][][][] leftInsertionCosts;
    private double[][][][] rightInsertionCosts;
    private List<Integer>[][][] substitutionSuccessors;
    private List<Pair<Integer, Integer>>[][][] fissionSuccessors;
    private static Random rand = new Random();

    public Encodings getEncodings() {
        return this.enc;
    }

    private int NC() {
        return this.enc.getNumberOfEqClasses();
    }

    private int alpha() {
        return this.enc.getNumberOfPhonemes();
    }

    public EditParam(Encodings enc, double[][][] deletionCosts, double[][][][] substitutionCosts, double[][][][][] fissionCosts) {
        this.enc = enc;
        this.deletionCosts = deletionCosts;
        this.substitutionCosts = substitutionCosts;
        this.rightInsertionCosts = this.insertions(fissionCosts, true);
        this.leftInsertionCosts = this.insertions(fissionCosts, false);
        this.computeSuccessors(deletionCosts, substitutionCosts, fissionCosts);
    }

    private double[][][][] insertions(double[][][][][] fissionCosts, boolean isRightInsertion) {
        int NC = this.enc.getNumberOfEqClasses();
        int alpha = this.enc.getNumberOfPhonemes();
        double[][][][] result = new double[NC][alpha][NC][alpha];
        for (int c1 = 0; c1 < this.NC(); ++c1) {
            for (int x = 0; x < this.alpha(); ++x) {
                for (int c2 = 0; c2 < this.NC(); ++c2) {
                    for (int y = 0; y < alpha; ++y) {
                        for (int z = 0; z < alpha; ++z) {
                            if (x != y && x != z && fissionCosts[c1][x][c2][y][z] != 0.0) {
                                throw new RuntimeException("Bad fission: " + new Edit(this.enc, c1, x, c2, y, z) + " : " + fissionCosts[c1][x][c2][y][z]);
                            }
                            if (isRightInsertion) {
                                if (x != y) continue;
                                result[c1][x][c2][z] = fissionCosts[c1][x][c2][y][z];
                                continue;
                            }
                            if (x != z) continue;
                            result[c1][x][c2][y] = fissionCosts[c1][x][c2][y][z];
                        }
                    }
                }
            }
        }
        return result;
    }

    public static EditParam createEditParam(Encodings enc, Initializer i) {
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        Initializer.access$002(i, new double[NC][alpha][NC]);
        Initializer.access$102(i, new double[NC][alpha][NC][alpha]);
        Initializer.access$202(i, new double[NC][alpha][NC][alpha][alpha]);
        i.process();
        return new EditParam(enc, i.deletionCosts, i.substitutionCosts, i.fissionCosts);
    }

    public static EditParam uniform(final Encodings enc) {
        final int bdry = enc.getBoundaryPhoneId();
        return EditParam.createEditParam(enc, new Initializer(){

            @Override
            public void process() {
                for (Edit e : Edit.allEdits(enc)) {
                    if (!e.isInDelSub() || !(e.y != bdry & e.z != bdry)) continue;
                    this.set(e, 1.0);
                }
            }
        }).normalize();
    }

    public static EditParam mix(final EditParam p1, final EditParam p2, final double pi) {
        return EditParam.createEditParam(p1.getEncodings(), new Initializer(){

            @Override
            public void process() {
                HashSet<Edit> support = new HashSet<Edit>();
                support.addAll(p1.toCounter().keySet());
                support.addAll(p2.toCounter().keySet());
                for (Edit e : support) {
                    this.set(e, this.mix(e, p1, p2, pi));
                }
            }

            private double mix(Edit e, EditParam p12, EditParam p22, double pi2) {
                assert (pi2 >= 0.0 && pi2 <= 1.0);
                double w1 = p12.cost(e);
                double w2 = p22.cost(e);
                return pi2 * w1 + (1.0 - pi2) * w2;
            }
        }).normalize();
    }

    private void computeSuccessors(double[][][] deletionCosts, double[][][][] substitutionCosts, double[][][][][] fissionCosts) {
        this.substitutionSuccessors = new List[this.NC()][this.alpha()][this.NC()];
        this.fissionSuccessors = new List[this.NC()][this.alpha()][this.NC()];
        for (int c1 = 0; c1 < this.NC(); ++c1) {
            for (int x = 0; x < this.alpha(); ++x) {
                for (int c2 = 0; c2 < this.NC(); ++c2) {
                    ArrayList<Integer> currentSubstitutionSuccessors = new ArrayList<Integer>();
                    ArrayList<Pair<Integer, Integer>> currentFissionSuccessors = new ArrayList<Pair<Integer, Integer>>();
                    this.substitutionSuccessors[c1][x][c2] = currentSubstitutionSuccessors;
                    this.fissionSuccessors[c1][x][c2] = currentFissionSuccessors;
                    for (int y = 0; y < this.alpha(); ++y) {
                        if (substitutionCosts[c1][x][c2][y] > 0.0) {
                            currentSubstitutionSuccessors.add(y);
                        }
                        for (int z = 0; z < this.alpha(); ++z) {
                            if (!(fissionCosts[c1][x][c2][y][z] > 0.0)) continue;
                            currentFissionSuccessors.add(new Pair<Integer, Integer>(y, z));
                        }
                    }
                }
            }
        }
    }

    public double deletionCost(int c1, int x, int c2) {
        return this.deletionCosts[c1][x][c2];
    }

    public double deletionCost(char c1, char x, char c2) {
        throw new RuntimeException("Dangerous overloading: use deletionCostFromCharacters instead.");
    }

    public double deletionCostFromCharacters(char c1, char x, char c2) {
        return this.deletionCost(this.enc.char2EqClassId(c1), this.enc.char2PhoneId(x), this.enc.char2EqClassId(c2));
    }

    public double substitutionCost(int c1, int x, int c2, int y) {
        return this.substitutionCosts[c1][x][c2][y];
    }

    public double substitutionCost(char c1, char x, char c2, char y) {
        throw new RuntimeException("Dangerous overloading: use substitutionCostFromCharacters instead.");
    }

    public double substitutionCostFromCharacters(char c1, char x, char c2, char y) {
        return this.substitutionCost(this.enc.char2EqClassId(c1), this.enc.char2PhoneId(x), this.enc.char2EqClassId(c2), this.enc.char2PhoneId(y));
    }

    public double fissionCost(int c1, int x, int c2, int y, int z) {
        if (x != y && x != z) {
            return 0.0;
        }
        if (x == y) {
            return this.rightInsertionCosts[c1][x][c2][z];
        }
        return this.leftInsertionCosts[c1][x][c2][y];
    }

    public double fissionCost(char c1, char x, char c2, char y, char z) {
        throw new RuntimeException("Dangerous overloading: use fissionCostFromCharacters instead.");
    }

    public double fissionCostFromCharacters(char c1, char x, char c2, char y, char z) {
        return this.fissionCost(this.enc.char2EqClassId(c1), this.enc.char2PhoneId(x), this.enc.char2EqClassId(c2), this.enc.char2PhoneId(y), this.enc.char2PhoneId(z));
    }

    public List<Integer> substitutionSuccessors(int c1, int x, int c2) {
        return this.substitutionSuccessors[c1][x][c2];
    }

    public List<Pair<Integer, Integer>> fissionSuccessors(int c1, int x, int c2) {
        return this.fissionSuccessors[c1][x][c2];
    }

    public static EditParam getSanityCheck(int i) {
        EditParam result = null;
        if (i == 1) {
            result = EditParam.getSanityCheck1();
        } else if (i == 2) {
            result = EditParam.getSanityCheck2();
        } else if (i == 3) {
            result = EditParam.getSanityCheck3();
        } else if (i == 4) {
            result = EditParam.getSanityCheck4();
        } else if (i == 5) {
            result = EditParam.getSanityCheck5();
        } else if (i == 6) {
            result = EditParam.getSanityCheck6(0.3333333333333333, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
        } else if (i == 7) {
            result = EditParam.getSanityCheck7(0.2, 0.3, 0.1, 0.15, 0.05, 0.1);
        } else {
            throw new RuntimeException();
        }
        return result.removeTransitionsToBoundary();
    }

    public static EditParam getSanityCheck5() {
        Encodings enc = Encodings.toyEncodings();
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        double[][][] deletionCosts = new double[NC][alpha][NC];
        double[][][][] substitutionCosts = new double[NC][alpha][NC][alpha];
        double[][][][][] fissionCosts = new double[NC][alpha][NC][alpha][alpha];
        int a = enc.char2PhoneId('a');
        int b = enc.char2PhoneId('b');
        for (int c1 = 0; c1 < NC; ++c1) {
            for (int c2 = 0; c2 < NC; ++c2) {
                substitutionCosts[c1][a][c2][a] = 0.3333333333333333;
                deletionCosts[c1][a][c2] = 0.3333333333333333;
                fissionCosts[c1][a][c2][a][b] = 0.3333333333333333;
                substitutionCosts[c1][b][c2][b] = 0.3333333333333333;
                deletionCosts[c1][b][c2] = 0.3333333333333333;
                fissionCosts[c1][b][c2][a][b] = 0.3333333333333333;
            }
        }
        return new EditParam(enc, deletionCosts, substitutionCosts, fissionCosts);
    }

    public static EditParam getSanityCheck1() {
        Encodings enc = Encodings.toyEncodings();
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        double[][][] deletionCosts = new double[NC][alpha][NC];
        double[][][][] substitutionCosts = new double[NC][alpha][NC][alpha];
        double[][][][][] fissionCosts = new double[NC][alpha][NC][alpha][alpha];
        for (int c1 = 0; c1 < NC; ++c1) {
            for (int c2 = 0; c2 < NC; ++c2) {
                int a = enc.char2PhoneId('a');
                int b = enc.char2PhoneId('b');
                int c = enc.char2PhoneId('c');
                substitutionCosts[c1][a][c2][b] = 1.0;
                substitutionCosts[c1][b][c2][c] = 1.0;
            }
        }
        return new EditParam(enc, deletionCosts, substitutionCosts, fissionCosts);
    }

    public EditParam removeTransitionsToBoundary() {
        int boundarySymbolId = this.enc.getBoundaryPhoneId();
        double[][][] deletionCosts = new double[this.NC()][this.alpha()][this.NC()];
        double[][][][] substitutionCosts = new double[this.NC()][this.alpha()][this.NC()][this.alpha()];
        double[][][][][] fissionCosts = new double[this.NC()][this.alpha()][this.NC()][this.alpha()][this.alpha()];
        for (int c1 = 0; c1 < this.NC(); ++c1) {
            for (int x = 0; x < this.alpha(); ++x) {
                for (int c2 = 0; c2 < this.NC(); ++c2) {
                    deletionCosts[c1][x][c2] = this.deletionCosts[c1][x][c2];
                    for (int y = 0; y < this.alpha(); ++y) {
                        substitutionCosts[c1][x][c2][y] = y == boundarySymbolId && x != boundarySymbolId ? 0.0 : this.substitutionCosts[c1][x][c2][y];
                        for (int z = 0; z < this.alpha(); ++z) {
                            fissionCosts[c1][x][c2][y][z] = y == boundarySymbolId || z == boundarySymbolId ? 0.0 : this.fissionCost(c1, x, c2, y, z);
                        }
                    }
                }
            }
        }
        return new EditParam(this.enc, deletionCosts, substitutionCosts, fissionCosts).normalize();
    }

    public EditParam normalize() {
        double[][][] deletionCosts = new double[this.NC()][this.alpha()][this.NC()];
        double[][][][] substitutionCosts = new double[this.NC()][this.alpha()][this.NC()][this.alpha()];
        double[][][][][] fissionCosts = new double[this.NC()][this.alpha()][this.NC()][this.alpha()][this.alpha()];
        for (int c1 = 0; c1 < this.NC(); ++c1) {
            for (int x = 0; x < this.alpha(); ++x) {
                for (int c2 = 0; c2 < this.NC(); ++c2) {
                    int z;
                    int y;
                    if (x == this.enc.getBoundaryPhoneId()) {
                        substitutionCosts[c1][x][c2][x] = 1.0;
                        continue;
                    }
                    double sum = 0.0;
                    sum += this.deletionCosts[c1][x][c2];
                    for (y = 0; y < this.alpha(); ++y) {
                        sum += this.substitutionCosts[c1][x][c2][y];
                        for (z = 0; z < this.alpha(); ++z) {
                            sum += this.fissionCost(c1, x, c2, y, z);
                        }
                    }
                    deletionCosts[c1][x][c2] = this.deletionCosts[c1][x][c2] / sum;
                    for (y = 0; y < this.alpha(); ++y) {
                        substitutionCosts[c1][x][c2][y] = this.substitutionCosts[c1][x][c2][y] / sum;
                        for (z = 0; z < this.alpha(); ++z) {
                            fissionCosts[c1][x][c2][y][z] = this.fissionCost(c1, x, c2, y, z) / sum;
                        }
                    }
                }
            }
        }
        return new EditParam(this.enc, deletionCosts, substitutionCosts, fissionCosts);
    }

    public static EditParam getSanityCheck2() {
        return EditParam.getSanityCheck2(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
    }

    public static EditParam getSanityCheck2(double del, double sub, double fis) {
        Encodings enc = Encodings.toyEncodings();
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        double[][][] deletionCosts = new double[NC][alpha][NC];
        double[][][][] substitutionCosts = new double[NC][alpha][NC][alpha];
        double[][][][][] fissionCosts = new double[NC][alpha][NC][alpha][alpha];
        int a = enc.char2PhoneId('a');
        for (int c1 = 0; c1 < NC; ++c1) {
            for (int c2 = 0; c2 < NC; ++c2) {
                substitutionCosts[c1][a][c2][a] = sub;
                deletionCosts[c1][a][c2] = del;
                fissionCosts[c1][a][c2][a][a] = fis;
            }
        }
        return new EditParam(enc, deletionCosts, substitutionCosts, fissionCosts);
    }

    public static EditParam getSanityCheck6(double a2a, double a2b, double b2a, double b2b, double c2a, double c2b) {
        Encodings enc = Encodings.toyCtxFreeEncodings(3);
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        double[][][] deletionCosts = new double[NC][alpha][NC];
        double[][][][] substitutionCosts = new double[NC][alpha][NC][alpha];
        double[][][][][] fissionCosts = new double[NC][alpha][NC][alpha][alpha];
        int a = enc.char2PhoneId('a');
        int b = enc.char2PhoneId('b');
        int c = enc.char2PhoneId('c');
        for (int c1 = 0; c1 < NC; ++c1) {
            for (int c2 = 0; c2 < NC; ++c2) {
                substitutionCosts[c1][a][c2][a] = a2a;
                substitutionCosts[c1][a][c2][b] = a2b;
                substitutionCosts[c1][a][c2][c] = 1.0 - a2b - a2a;
                substitutionCosts[c1][b][c2][a] = b2a;
                substitutionCosts[c1][b][c2][b] = b2b;
                substitutionCosts[c1][b][c2][c] = 1.0 - b2a - b2b;
                substitutionCosts[c1][c][c2][a] = c2a;
                substitutionCosts[c1][c][c2][b] = c2b;
                substitutionCosts[c1][c][c2][c] = 1.0 - c2a - c2b;
            }
        }
        EditParam result = new EditParam(enc, deletionCosts, substitutionCosts, fissionCosts);
        if (!result.isNormalized(true)) {
            throw new RuntimeException();
        }
        return result;
    }

    public static EditParam getSanityCheck7(double a2b, double b2a, double aIns, double bIns, double aDel, double bDel) {
        Encodings enc = Encodings.toyCtxFreeEncodings(2);
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        double[][][] deletionCosts = new double[NC][alpha][NC];
        double[][][][] substitutionCosts = new double[NC][alpha][NC][alpha];
        double[][][][][] fissionCosts = new double[NC][alpha][NC][alpha][alpha];
        int a = enc.char2PhoneId('a');
        int b = enc.char2PhoneId('b');
        int ctxt = enc.getBoundaryEqClassId();
        assert (enc.getNumberOfEqClasses() == 1);
        substitutionCosts[ctxt][a][ctxt][b] = a2b;
        substitutionCosts[ctxt][b][ctxt][a] = b2a;
        fissionCosts[ctxt][a][ctxt][a][a] = aIns;
        fissionCosts[ctxt][b][ctxt][b][a] = aIns;
        fissionCosts[ctxt][a][ctxt][a][b] = bIns;
        fissionCosts[ctxt][b][ctxt][b][b] = bIns;
        deletionCosts[ctxt][a][ctxt] = aDel;
        deletionCosts[ctxt][b][ctxt] = bDel;
        substitutionCosts[ctxt][a][ctxt][a] = 1.0 - a2b - aIns - bIns - aDel;
        substitutionCosts[ctxt][b][ctxt][b] = 1.0 - b2a - aIns - bIns - bDel;
        EditParam result = new EditParam(enc, deletionCosts, substitutionCosts, fissionCosts);
        if (!result.isNormalized(true)) {
            throw new RuntimeException("Not normalized:\n" + result.toString());
        }
        return result;
    }

    public static EditParam getSanityCheck3() {
        Encodings enc = Encodings.toyEncodings();
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        double[][][] deletionCosts = new double[NC][alpha][NC];
        double[][][][] substitutionCosts = new double[NC][alpha][NC][alpha];
        double[][][][][] fissionCosts = new double[NC][alpha][NC][alpha][alpha];
        int a = enc.char2PhoneId('a');
        int b = enc.char2PhoneId('b');
        int boundary = enc.phoneId2EqClassId(enc.getBoundaryPhoneId());
        for (int c1 = 0; c1 < NC; ++c1) {
            for (int c2 = 0; c2 < NC; ++c2) {
                substitutionCosts[c1][a][c2][a] = 0.3333333333333333;
                deletionCosts[c1][a][c2] = 0.3333333333333333;
                fissionCosts[c1][a][c2][a][a] = 0.3333333333333333;
                if (c1 == boundary) {
                    substitutionCosts[c1][b][c2][b] = 1.0;
                    continue;
                }
                substitutionCosts[c1][b][c2][b] = 0.3333333333333333;
                deletionCosts[c1][b][c2] = 0.3333333333333333;
                fissionCosts[c1][b][c2][b][b] = 0.3333333333333333;
            }
        }
        return new EditParam(enc, deletionCosts, substitutionCosts, fissionCosts);
    }

    public static EditParam getSanityCheck4() {
        Encodings enc = Encodings.toyEncodings();
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        double[][][] deletionCosts = new double[NC][alpha][NC];
        double[][][][] substitutionCosts = new double[NC][alpha][NC][alpha];
        double[][][][][] fissionCosts = new double[NC][alpha][NC][alpha][alpha];
        int a = enc.char2PhoneId('a');
        int b = enc.char2PhoneId('b');
        int c = enc.char2PhoneId('c');
        int boundary = enc.phoneId2EqClassId(enc.getBoundaryPhoneId());
        for (int c1 = 0; c1 < NC; ++c1) {
            for (int c2 = 0; c2 < NC; ++c2) {
                substitutionCosts[c1][a][c2][a] = 1.0;
                substitutionCosts[c1][b][c2][b] = 1.0;
                substitutionCosts[c1][c][c2][c] = 1.0;
                substitutionCosts[c1][a][c2][b] = 1.0;
                substitutionCosts[c1][b][c2][c] = 1.0;
            }
        }
        return new EditParam(enc, deletionCosts, substitutionCosts, fissionCosts);
    }

    public static String generate(String input, EditParam edits) {
        Encodings enc = edits.enc;
        StringBuilder result = new StringBuilder();
        int boundary = enc.getBoundaryPhoneId();
        int NC = enc.getNumberOfEqClasses();
        int alpha = enc.getNumberOfPhonemes();
        block0: for (int i = 0; i < input.length(); ++i) {
            int y;
            char current = input.charAt(i);
            int x = enc.char2PhoneId(current);
            int c1 = -1;
            if (i - 1 >= 0) {
                char previous = input.charAt(i - 1);
                c1 = enc.phoneId2EqClassId(enc.char2PhoneId(previous));
            } else {
                c1 = enc.phoneId2EqClassId(boundary);
            }
            int c2 = -1;
            if (i + 1 < input.length()) {
                char next = input.charAt(i + 1);
                c2 = enc.phoneId2EqClassId(enc.char2PhoneId(next));
            } else {
                c2 = enc.phoneId2EqClassId(boundary);
            }
            double sum = 0.0;
            double random = rand.nextDouble();
            if (random < (sum += edits.deletionCost(c1, x, c2))) continue;
            for (y = 0; y < alpha; ++y) {
                if (!(random < (sum += edits.substitutionCost(c1, x, c2, y)))) continue;
                result.append(enc.phoneId2Char(y));
                continue block0;
            }
            for (y = 0; y < alpha; ++y) {
                for (int z = 0; z < alpha; ++z) {
                    if (!(random < (sum += edits.fissionCost(c1, x, c2, y, z)))) continue;
                    result.append(enc.phoneId2Char(y));
                    result.append(enc.phoneId2Char(z));
                    continue block0;
                }
            }
            throw new RuntimeException("The \"probabilitis\" did not sum up to 1!");
        }
        return result.toString();
    }

    public static void testRejectionSampling(EditParam param, String top, String bottom) {
        RejectionSampler sampler = new RejectionSampler(param, param, top, bottom);
        MCIntegrator<String> integrator = new MCIntegrator<String>(sampler);
        integrator.setIterations(100000);
        ArrayList<Indicator<String>> fcts = new ArrayList<Indicator<String>>();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                fcts.add(new Indicator<String>(EditParam.repeat("a", i) + EditParam.repeat("b", j)));
            }
        }
        List<Double> result = integrator.integrate(fcts);
        System.out.println("\t0\t1\t2");
        for (int a_index = 0; a_index < 3; ++a_index) {
            System.out.print("" + a_index + "\t");
            for (int b_index = 0; b_index < 3; ++b_index) {
                System.out.print("" + result.get(b_index + 3 * a_index) + "\t");
            }
            System.out.print("\n");
        }
    }

    public static String repeat(String x, int n) {
        StringBuilder result = new StringBuilder();
        result.append("");
        for (int i = 0; i < n; ++i) {
            result.append(x);
        }
        return result.toString();
    }

    public static void main(String[] args) throws IOException {
        Encodings enc = Encodings.toyEncodings();
        int a = enc.char2PhoneId('a');
        int b = enc.char2PhoneId('b');
        int c1 = enc.phoneId2EqClassId(a);
        int boundary = enc.char2PhoneId('#');
        if (boundary != enc.getBoundaryPhoneId()) {
            throw new RuntimeException("!");
        }
        int c2 = enc.phoneId2EqClassId(boundary);
        EditParam p = EditParam.getSanityCheck3();
        EditParam.testRejectionSampling(p, "ab", "b");
    }

    public Counter<Edit> toCounter() {
        Counter<Edit> result = new Counter<Edit>();
        for (int c1 = 0; c1 < this.NC(); ++c1) {
            for (int x = 0; x < this.alpha(); ++x) {
                for (int c2 = 0; c2 < this.NC(); ++c2) {
                    if (this.deletionCost(c1, x, c2) > 0.0) {
                        result.incrementCount(new Edit(this.enc, c1, x, c2), this.deletionCost(c1, x, c2));
                    }
                    for (Integer n : this.substitutionSuccessors(c1, x, c2)) {
                        result.incrementCount(new Edit(this.enc, c1, x, c2, n), this.substitutionCost(c1, x, c2, n));
                    }
                    for (Pair pair : this.fissionSuccessors(c1, x, c2)) {
                        result.incrementCount(new Edit(this.enc, c1, x, c2, (Integer)pair.getFirst(), (Integer)pair.getSecond()), this.fissionCost(c1, x, c2, (Integer)pair.getFirst(), (Integer)pair.getSecond()));
                    }
                }
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int c1 = 0; c1 < this.NC(); ++c1) {
            for (int x = 0; x < this.alpha(); ++x) {
                for (int c2 = 0; c2 < this.NC(); ++c2) {
                    String env = this.enc.getEqClassDescription(c1) + " " + this.enc.phoneId2Char(x) + " " + this.enc.getEqClassDescription(c2);
                    builder.append("In the env. " + env + "\n");
                    if (this.deletionCosts[c1][x][c2] > 0.0) {
                        builder.append("\t" + new Edit(this.enc, c1, x, c2).toString() + " : " + this.deletionCosts[c1][x][c2] + "\n");
                    }
                    for (int y = 0; y < this.alpha(); ++y) {
                        if (this.substitutionCosts[c1][x][c2][y] > 0.0) {
                            builder.append("\t" + new Edit(this.enc, c1, x, c2, y).toString() + " : " + this.substitutionCosts[c1][x][c2][y] + "\n");
                        }
                        for (int z = 0; z < this.alpha(); ++z) {
                            if (!(this.fissionCost(c1, x, c2, y, z) > 0.0)) continue;
                            builder.append("\t" + new Edit(this.enc, c1, x, c2, y, z).toString() + " : " + this.fissionCost(c1, x, c2, y, z) + "\n");
                        }
                    }
                }
            }
        }
        return builder.toString();
    }

    public double cost(Edit edit) {
        if (edit.isSubstitution()) {
            return this.substitutionCost(edit.c1, edit.x, edit.c2, edit.y);
        }
        if (edit.isFission()) {
            return this.fissionCost(edit.c1, edit.x, edit.c2, edit.y, edit.z);
        }
        return this.deletionCost(edit.c1, edit.x, edit.c2);
    }

    public static EditParam parseEditParam(Encodings enc, String file) throws NumberFormatException, IOException {
        Counter<Edit> edits = new Counter<Edit>();
        for (String line : IO.i(file)) {
            if (line.matches("^\\s*.*\\s*[:\\t]\\s*[.0-9]+\\s*$")) {
                String editString = StringUtils.selectRegex("^\\t*\\s*(.*)\\s*[:\\t]\\s*[.0-9]+\\s*$", line).get(0);
                Edit edit = Edit.parseEdit(enc, editString);
                String weightString = StringUtils.selectRegex("^\\t*\\s*.*\\s*[:\\t]\\s*([.0-9]+)\\s*$", line).get(0);
                double weigth = Double.parseDouble(weightString);
                edits.setCount(edit, weigth);
                continue;
            }
            if (line.matches("^[#].*$") || line.matches("^[ ]*$")) continue;
            throw new RuntimeException();
        }
        return EditParam.createEditParams(enc, edits);
    }

    private static EditParam createEditParams(Encodings enc, Counter<Edit> edits) {
        int alpha = enc.getNumberOfPhonemes();
        int NC = enc.getNumberOfEqClasses();
        double[][][] deletionCosts = new double[NC][alpha][NC];
        double[][][][] substitutionCosts = new double[NC][alpha][NC][alpha];
        double[][][][][] fissionCosts = new double[NC][alpha][NC][alpha][alpha];
        for (Edit edit : edits) {
            if (!edit.getEncodings().equals(enc)) {
                throw new RuntimeException();
            }
            double weigth = edits.getCount(edit);
            if (weigth < 0.0) {
                throw new RuntimeException();
            }
            if (edit.isDeletion()) {
                deletionCosts[edit.c1][edit.x][edit.c2] = weigth;
                continue;
            }
            if (edit.isSubstitution()) {
                substitutionCosts[edit.c1][edit.x][edit.c2][edit.y] = weigth;
                continue;
            }
            if (edit.isFission()) {
                fissionCosts[edit.c1][edit.x][edit.c2][edit.y][edit.z] = weigth;
                continue;
            }
            throw new RuntimeException();
        }
        return new EditParam(enc, deletionCosts, substitutionCosts, fissionCosts).normalize();
    }

    public static EditParam pruneLowProb(EditParam params, double threshold) {
        assert (params.isNormalized());
        int A = params.enc.getNumberOfPhonemes();
        int NC = params.enc.getNumberOfEqClasses();
        double[][][] deletionCosts = new double[NC][A][NC];
        double[][][][] substitutionCosts = new double[NC][A][NC][A];
        double[][][][][] fissionCosts = new double[NC][A][NC][A][A];
        for (int c1 = 0; c1 < NC; ++c1) {
            for (int x = 0; x < A; ++x) {
                for (int c2 = 0; c2 < NC; ++c2) {
                    PruneInfo info = new PruneInfo(threshold);
                    deletionCosts[c1][x][c2] = EditParam.prune(params.deletionCost(c1, x, c2), info);
                    for (int y = 0; y < A; ++y) {
                        substitutionCosts[c1][x][c2][y] = EditParam.prune(params.substitutionCost(c1, x, c2, y), info);
                        for (int z = 0; z < A; ++z) {
                            fissionCosts[c1][x][c2][y][z] = EditParam.prune(params.fissionCost(c1, x, c2, y, z), info);
                        }
                    }
                    double increment = info.leftovers / (double)info.numberOfActiveRules;
                    deletionCosts[c1][x][c2] = EditParam.reWeigth(deletionCosts[c1][x][c2], increment);
                    for (int y = 0; y < A; ++y) {
                        substitutionCosts[c1][x][c2][y] = EditParam.reWeigth(substitutionCosts[c1][x][c2][y], increment);
                        for (int z = 0; z < A; ++z) {
                            fissionCosts[c1][x][c2][y][z] = EditParam.reWeigth(fissionCosts[c1][x][c2][y][z], increment);
                        }
                    }
                }
            }
        }
        return new EditParam(params.enc, deletionCosts, substitutionCosts, fissionCosts);
    }

    private static double prune(double value, PruneInfo info) {
        if (value < info.threshold) {
            return 0.0;
        }
        info.leftovers = info.leftovers - value;
        info.numberOfActiveRules++;
        return value;
    }

    private static double reWeigth(double value, double increment) {
        if (value == 0.0) {
            return 0.0;
        }
        return value + increment;
    }

    public boolean isNormalized(boolean allowUnspecified) {
        for (int c1 = 0; c1 < this.NC(); ++c1) {
            for (int x = 0; x < this.alpha(); ++x) {
                for (int c2 = 0; c2 < this.NC(); ++c2) {
                    double sum = 0.0;
                    sum += this.deletionCosts[c1][x][c2];
                    for (int y = 0; y < this.alpha(); ++y) {
                        sum += this.substitutionCosts[c1][x][c2][y];
                        for (int z = 0; z < this.alpha(); ++z) {
                            sum += this.fissionCost(c1, x, c2, y, z);
                        }
                    }
                    if (!(sum > 1.001) && !(sum < 0.999) || allowUnspecified && sum == 0.0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isNormalized() {
        return this.isNormalized(false);
    }

    private static class PruneInfo {
        private double threshold;
        private double leftovers = 1.0;
        private int numberOfActiveRules = 0;

        private PruneInfo(double threshold) {
            this.threshold = threshold;
        }
    }

    public static class RejectionSampler
    implements Sampler<String> {
        private final String top;
        private final String bottom;
        private final EditParam param1;
        private final EditParam param2;
        private static final int trials = 10000;

        public RejectionSampler(EditParam p1, EditParam p2, String top, String bottom) {
            this.top = top;
            this.bottom = bottom;
            this.param1 = p1;
            this.param2 = p2;
        }

        @Override
        public double previousSampleWeigth() {
            return 1.0;
        }

        @Override
        public String sample() {
            for (int i = 0; i < 10000; ++i) {
                String middle = EditParam.generate(this.top, this.param1);
                if (!EditParam.generate(middle, this.param2).equals(this.bottom)) continue;
                return middle;
            }
            throw new RuntimeException("Seems to be conditioning on an event of pr 0!");
        }
    }

    public static abstract class Initializer {
        private double[][][] deletionCosts;
        private double[][][][] substitutionCosts;
        private double[][][][][] fissionCosts;

        public final void set(Edit e, double value) {
            if (e.isDeletion()) {
                this.deletionCosts[e.c1][e.x][e.c2] = value;
            }
            if (e.isSubstitution()) {
                this.substitutionCosts[e.c1][e.x][e.c2][e.y] = value;
            }
            if (e.isFission()) {
                this.fissionCosts[e.c1][e.x][e.c2][e.y][e.z] = value;
            }
        }

        public abstract void process();

        static /* synthetic */ double[][][] access$002(Initializer x0, double[][][] x1) {
            x0.deletionCosts = x1;
            return x1;
        }

        static /* synthetic */ double[][][][] access$102(Initializer x0, double[][][][] x1) {
            x0.substitutionCosts = x1;
            return x1;
        }

        static /* synthetic */ double[][][][][] access$202(Initializer x0, double[][][][][] x1) {
            x0.fissionCosts = x1;
            return x1;
        }
    }
}

