/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.ListUtils;
import fig.basic.NumUtils;
import fig.prob.Multinomial;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import pepper.Edit;
import pepper.Encodings;
import pepper.editmodel.EditParam;

public class ObservedWordSampler {
    private double[][] sumProb;
    private EditParam param;
    private String sourceStr;
    private String destStr;
    private int nSource;
    private int nDest;
    private int nc;
    private int[] source;
    private int[] dest;
    private int boundaryc;
    private List<Edit> sample;
    private boolean[][] sampledPath;
    private boolean failure = false;
    private Random random;

    public Encodings getEncodings() {
        return this.param.getEncodings();
    }

    public ObservedWordSampler(Random random, EditParam param, String topStr, String bottomStr) {
        this.random = random;
        this.param = param;
        this.sourceStr = topStr;
        this.destStr = bottomStr;
        this.nSource = topStr.length();
        this.nDest = bottomStr.length();
        this.source = this.getEncodings().string2PhoneIds(topStr);
        this.dest = this.getEncodings().string2PhoneIds(bottomStr);
        this.nc = this.getEncodings().getNumberOfEqClasses();
        this.boundaryc = this.getEncodings().getBoundaryEqClassId();
        this.sumProb = new double[topStr.length()][bottomStr.length() + 1];
        for (int s = 0; s < this.nSource; ++s) {
            for (int d = 0; d < this.nDest + 1; ++d) {
                this.sumProb[s][d] = -1.0;
            }
        }
    }

    public List<Edit> sample(boolean viterbi) {
        this.failure = false;
        this.sampledPath = new boolean[this.nSource][this.nDest];
        this.sample = new ArrayList<Edit>();
        this.failure = !this.sample(0, 0, viterbi);
        return this.sample;
    }

    public boolean isFailure() {
        return this.failure;
    }

    public double sumPr() {
        return this.sumProb(0, 0);
    }

    public String transitions() {
        StringBuilder builder = new StringBuilder();
        for (int s = 0; s < this.nSource; ++s) {
            for (int d = 0; d < this.nDest + 1; ++d) {
                builder.append("" + this.sumProb(s, d) + "\t");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private boolean sample(int s, int d, boolean viterbi) {
        if (s == this.nSource && d == this.nDest) {
            return true;
        }
        if (s >= this.nSource || d >= this.nDest + 1) {
            return false;
        }
        double[] prs = new double[]{this.deletionSumPr(s, d), this.substSumPr(s, d), this.fissionSumPr(s, d)};
        if (prs[0] + prs[1] + prs[2] == 0.0) {
            return false;
        }
        int decision = -1;
        if (viterbi) {
            decision = ListUtils.maxIndex(prs);
        } else {
            NumUtils.normalize(prs);
            decision = Multinomial.sample(this.random, prs);
        }
        int c1 = this.topc(s - 1);
        int x = this.source[s];
        int c2 = this.topc(s + 1);
        if (decision == 0) {
            this.sample.add(new Edit(this.getEncodings(), c1, x, c2));
            return this.sample(s + 1, d, viterbi);
        }
        if (decision == 1) {
            int y = this.dest[d];
            this.sample.add(new Edit(this.getEncodings(), c1, x, c2, y));
            this.sampledPath[s][d] = true;
            return this.sample(s + 1, d + 1, viterbi);
        }
        int y = this.dest[d];
        int z = this.dest[d + 1];
        this.sample.add(new Edit(this.getEncodings(), c1, x, c2, y, z));
        this.sampledPath[s][d] = true;
        this.sampledPath[s][d + 1] = true;
        return this.sample(s + 1, d + 2, viterbi);
    }

    private double sumProb(int s, int d) {
        if (s == this.nSource && d == this.nDest) {
            return 1.0;
        }
        if (s >= this.nSource) {
            return 0.0;
        }
        if (d >= this.nDest + 1) {
            return 0.0;
        }
        if (this.sumProb[s][d] != -1.0) {
            return this.sumProb[s][d];
        }
        this.sumProb[s][d] = this.deletionSumPr(s, d) + this.substSumPr(s, d) + this.fissionSumPr(s, d);
        return this.sumProb[s][d];
    }

    private double deletionSumPr(int s, int d) {
        double recursion = this.sumProb(s + 1, d);
        if (recursion != 0.0) {
            int c1 = this.topc(s - 1);
            int x = this.source[s];
            int c2 = this.topc(s + 1);
            return recursion * this.param.deletionCost(c1, x, c2);
        }
        return 0.0;
    }

    private double substSumPr(int s, int d) {
        double recursion = this.sumProb(s + 1, d + 1);
        if (recursion != 0.0) {
            int c1 = this.topc(s - 1);
            int x = this.source[s];
            int c2 = this.topc(s + 1);
            int y = this.dest[d];
            return recursion * this.param.substitutionCost(c1, x, c2, y);
        }
        return 0.0;
    }

    private double fissionSumPr(int s, int d) {
        double recursion = this.sumProb(s + 1, d + 2);
        if (recursion != 0.0) {
            int c1 = this.topc(s - 1);
            int x = this.source[s];
            int c2 = this.topc(s + 1);
            int y = this.dest[d];
            int z = this.dest[d + 1];
            double oneStepCost = this.param.fissionCost(c1, x, c2, y, z);
            return recursion * oneStepCost;
        }
        return 0.0;
    }

    public String sampledPath2String() {
        StringBuilder builder = new StringBuilder();
        builder.append(' ');
        for (int d = 0; d < this.nDest; ++d) {
            builder.append(this.destStr.charAt(d));
        }
        for (int s = 0; s < this.nSource; ++s) {
            builder.append("\n");
            builder.append(this.sourceStr.charAt(s));
            for (int d = 0; d < this.nDest; ++d) {
                if (this.sampledPath[s][d]) {
                    builder.append('X');
                    continue;
                }
                builder.append(' ');
            }
        }
        return builder.toString();
    }

    private int topc(int i) {
        return i >= 0 && i < this.source.length ? this.x2c(this.source[i]) : this.boundaryc;
    }

    private int x2c(int x) {
        return this.getEncodings().phoneId2EqClassId(x);
    }
}

