/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import java.util.ArrayList;
import java.util.List;
import nuts.lang.StringUtils;

public class TreeTopology {
    private List<TreeTopology> children;
    private boolean sharesParentParameters;
    private String nameOfLang;
    private int DFSOrder;
    private boolean isRoot = false;
    private boolean loadFromFile;
    private static int currentDFSOrder = -1;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.sharesParentParameters ? "(" : "[");
        builder.append(this.nameOfLang);
        if (this.loadFromFile) {
            builder.append("*");
        }
        for (TreeTopology child : this.children) {
            builder.append(" " + child.toString());
        }
        builder.append(this.sharesParentParameters ? ")" : "]");
        return builder.toString();
    }

    public boolean isHidden() {
        return !this.loadFromFile;
    }

    public static TreeTopology parse(String specs) {
        currentDFSOrder = 0;
        TreeTopology result = TreeTopology.recParse(specs);
        result.isRoot = true;
        return result;
    }

    private static TreeTopology recParse(String specs) {
        TreeTopology result = new TreeTopology();
        result.sharesParentParameters = specs.matches("^\\(.+\\)");
        result.nameOfLang = StringUtils.selectRegex("^.(\\w+)", specs).get(0);
        int indexInFileStringLength = 0;
        if (specs.matches("^.\\w+[*].*")) {
            result.loadFromFile = true;
            indexInFileStringLength = 1;
        }
        result.DFSOrder = currentDFSOrder++;
        result.children = new ArrayList<TreeTopology>();
        String childSpec = specs.substring(1 + result.nameOfLang.length() + indexInFileStringLength);
        while (childSpec.charAt(0) == ' ') {
            childSpec = childSpec.substring(1);
            TreeTopology child = TreeTopology.recParse(childSpec);
            result.children.add(child);
            childSpec = childSpec.substring(child.toString().length());
        }
        return result;
    }

    public static void main(String[] args) {
        String test = "(la* [la_es (es*)] [la_it (it*)])";
        System.out.println(TreeTopology.parse(test));
    }

    public static int getCurrentDFSOrder() {
        return currentDFSOrder;
    }

    public List<TreeTopology> getChildren() {
        ArrayList<TreeTopology> result = new ArrayList<TreeTopology>();
        result.addAll(this.children);
        return result;
    }

    public int getDFSOrder() {
        return this.DFSOrder;
    }

    public String getNameOfLang() {
        return this.nameOfLang;
    }

    public boolean sharesParentParameters() {
        return this.sharesParentParameters;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public List<TreeTopology> getDesc() {
        ArrayList<TreeTopology> result = new ArrayList<TreeTopology>();
        result.add(this);
        for (TreeTopology child : this.children) {
            result.addAll(child.getDesc());
        }
        return result;
    }
}

