/*
 * Decompiled with CFR 0.152.
 */
package pty;

import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import nuts.util.CollUtils;
import nuts.util.MathUtils;
import pty.RootedTree;

public class RandomRootedTrees {
    public static RootedTree sampleUnif(Random rand, int nTax) {
        return RandomRootedTrees.sampleUnif(rand, RandomRootedTrees.generateLeafNames(nTax));
    }

    public static RootedTree sampleUnif(Random rand, Collection<Taxon> leaves) {
        return RandomRootedTrees.sample(rand, leaves, Double.NaN, false, true);
    }

    public static RootedTree sampleCoalescent(Random rand, int nTax, double rate) {
        return RandomRootedTrees.sampleCoalescent(rand, RandomRootedTrees.generateLeafNames(nTax), rate);
    }

    public static RootedTree sampleCoalescent(Random rand, Collection<Taxon> leaves, double rate) {
        return RandomRootedTrees.sample(rand, leaves, rate, false);
    }

    public static RootedTree sampleYule(Random rand, int nTax, double rate) {
        return RandomRootedTrees.sampleYule(rand, RandomRootedTrees.generateLeafNames(nTax), rate);
    }

    public static RootedTree sampleYule(Random rand, Collection<Taxon> leaves, double rate) {
        return RandomRootedTrees.sample(rand, leaves, rate, true);
    }

    private static RootedTree sample(Random rand, Collection<Taxon> leaves, double rate, boolean yule) {
        return RandomRootedTrees.sample(rand, leaves, rate, yule, false);
    }

    private static RootedTree sample(Random rand, Collection<Taxon> leaves, double rate, boolean yule, boolean unif) {
        if (unif && yule) {
            throw new RuntimeException();
        }
        ArrayList current = CollUtils.list();
        ArrayList heights = CollUtils.list();
        double currentMaxHeight = 0.0;
        for (Taxon t : leaves) {
            current.add(RootedTree.Util.singleton(t));
            heights.add(0.0);
        }
        int i = 0;
        while (current.size() > 1) {
            double newMaxHeight;
            int n = current.size();
            double currentRate = rate * (double)(yule ? n : MathUtils.nChoose2(n));
            double delta = unif ? Sampling.nextDouble(rand, 0.0, 1.0) : Sampling.sampleExponential(rand, 1.0 / currentRate);
            List<Integer> pair = Sampling.sampleWithoutReplacement(rand, current.size(), 2);
            RootedTree first = (RootedTree)current.get(pair.get(0));
            RootedTree second = (RootedTree)current.get(pair.get(1));
            double firstH = (Double)heights.get(pair.get(0));
            double secondH = (Double)heights.get(pair.get(1));
            current.remove(Math.max(pair.get(0), pair.get(1)));
            current.remove(Math.min(pair.get(0), pair.get(1)));
            heights.remove(Math.max(pair.get(0), pair.get(1)));
            heights.remove(Math.min(pair.get(0), pair.get(1)));
            currentMaxHeight = newMaxHeight = currentMaxHeight + delta;
            double left = currentMaxHeight - firstH;
            double right = currentMaxHeight - secondH;
            RootedTree newTree = RootedTree.Util.coalesce(new Taxon("internal_" + i++), first, second, left, right);
            current.add(newTree);
            heights.add(currentMaxHeight);
        }
        return (RootedTree)current.get(0);
    }

    public static List<Taxon> generateLeafNames(int nTax) {
        ArrayList<Taxon> rst = CollUtils.list();
        for (int i = 0; i < nTax; ++i) {
            rst.add(new Taxon("leaf_" + i));
        }
        return rst;
    }

    public static void main(String[] args) {
        Random rand = new Random(1L);
        RootedTree rt = RandomRootedTrees.sampleYule(rand, 10, 1.0);
        System.out.println(rt);
    }
}

