/*
 * Decompiled with CFR 0.152.
 */
package pty;

import conifer.Phylogeny;
import fig.basic.IOUtils;
import fig.basic.UnorderedPair;
import goblin.CognateId;
import goblin.DataPrepUtils;
import goblin.Taxon;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ma.BioCorpus;
import ma.newick.NewickParser;
import ma.newick.ParseException;
import nuts.math.Sampling;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import nuts.util.Tree;
import pty.UnrootedTree;

public interface RootedTree
extends Phylogeny {
    public Arbre<Taxon> topology();

    public Map<Taxon, Double> branchLengths();

    public static class Util {
        public static RootedTree translate(RootedTree rt, Map<Taxon, Taxon> translation) {
            Arbre<Taxon> translatedA = Arbre.map(rt.topology(), translation);
            HashMap<Taxon, Double> translatedBL = CollUtils.map();
            for (Taxon t : rt.branchLengths().keySet()) {
                translatedBL.put(translation.get(t), rt.branchLengths().get(t));
            }
            return new RootedTreeImpl(translatedA, translatedBL);
        }

        public static RootedTree normalizeBranches(RootedTree rt) {
            double sum = 0.0;
            for (Taxon t : rt.branchLengths().keySet()) {
                sum += rt.branchLengths().get(t).doubleValue();
            }
            HashMap<Taxon, Double> newBLs = CollUtils.map();
            for (Taxon t : rt.branchLengths().keySet()) {
                newBLs.put(t, rt.branchLengths().get(t) / sum);
            }
            return new RootedTreeImpl(rt.topology(), newBLs);
        }

        public static RootedTree coalesce(Taxon newRoot, RootedTree rt1, RootedTree rt2, double bl1, double bl2) {
            Arbre<Taxon> left = rt1.topology().copy();
            Arbre<Taxon> right = rt2.topology().copy();
            Arbre<Taxon> newTree = Arbre.arbreWithChildren(newRoot, left, right);
            HashMap<Taxon, Double> bls = CollUtils.map();
            bls.putAll(rt1.branchLengths());
            bls.putAll(rt2.branchLengths());
            bls.put(left.getContents(), bl1);
            bls.put(right.getContents(), bl2);
            return new RootedTreeImpl(newTree, bls);
        }

        public static RootedTreeImpl incrementSmallBranches(RootedTree rt, double min) {
            Map<Taxon, Double> incrementSmallBranches = Util.incrementSmallBranches(rt.branchLengths(), min);
            return new RootedTreeImpl(rt.topology(), incrementSmallBranches);
        }

        public static Map<Taxon, Double> incrementSmallBranches(Map<Taxon, Double> bls, double min) {
            HashMap<Taxon, Double> result = CollUtils.map();
            for (Taxon l : bls.keySet()) {
                if (bls.get(l) < min) {
                    result.put(l, min);
                    continue;
                }
                result.put(l, bls.get(l));
            }
            return result;
        }

        public static RootedTree restrict(RootedTree rt, Set<Taxon> toRetain) {
            Tree<Taxon> t = Arbre.arbre2Tree(rt.topology());
            t = Util.restrict(t, toRetain);
            t = Util.removeUselessInternalNodes(t);
            HashMap<Taxon, Double> bls = CollUtils.map();
            UnrootedTree originalUT = UnrootedTree.fromRooted(rt);
            Arbre<Taxon> a = Arbre.tree2Arbre(t);
            for (Arbre<Taxon> subt : a.nodes()) {
                if (subt.isRoot()) continue;
                bls.put(subt.getContents(), originalUT.totalBranchLengthDistance(subt.getContents(), subt.getParent().getContents()));
            }
            return new RootedTreeImpl(a, bls);
        }

        public static Tree<Taxon> restrict(Tree<Taxon> t, Set<Taxon> toRetain) {
            if (t.isLeaf()) {
                return toRetain.contains(t.getLabel()) ? t : null;
            }
            ArrayList newChildren = new ArrayList();
            Tree<Taxon> cur = null;
            for (Tree<Taxon> child : t.getChildren()) {
                cur = Util.restrict(child, toRetain);
                if (cur == null) continue;
                newChildren.add(cur);
            }
            return newChildren.size() == 0 ? null : new Tree<Taxon>(t.getLabel(), newChildren);
        }

        public static Tree<Taxon> removeUselessInternalNodes(Tree<Taxon> t) {
            ArrayList newChildren = new ArrayList();
            if (t.getChildren().size() == 1) {
                return Util.removeUselessInternalNodes(t.getChildren().get(0));
            }
            for (Tree<Taxon> child : t.getChildren()) {
                newChildren.add(Util.removeUselessInternalNodes(child));
            }
            return new Tree<Taxon>(t.getLabel(), newChildren);
        }

        public static RootingInfo getRootingInfo(RootedTree rt) {
            if (rt.topology().getChildren().size() != 2) {
                throw new RuntimeException();
            }
            Taxon l1 = rt.topology().getChildren().get(0).getContents();
            Taxon l2 = rt.topology().getChildren().get(1).getContents();
            double b1 = rt.branchLengths().get(l1);
            double b2 = rt.branchLengths().get(l2);
            return new RootingInfo(l1, l2, rt.topology().getContents(), b1 / (b1 + b2));
        }

        public static RootedTree create(Arbre<Taxon> topo, Map<Taxon, Double> bl) {
            return new RootedTreeImpl(topo, bl);
        }

        public static String toString(final RootedTree nct) {
            return nct.topology().preOrderMap(new Arbre.ArbreMap<Taxon, String>(){

                @Override
                public String map(Arbre<Taxon> currentDomainNode) {
                    return currentDomainNode.getContents().toString() + (currentDomainNode.isRoot() ? "" : ":" + nct.branchLengths().get(currentDomainNode.getContents()));
                }
            }).deepToString();
        }

        public static String toNewick(RootedTree rt) {
            return DataPrepUtils.newick(Arbre.arbre2Tree(rt.topology()), rt.branchLengths(), false);
        }

        public static RootedTree fromBalibase(BioCorpus bc, CognateId id) {
            Tree<String> rawTopo = bc.getTopology(id);
            Arbre<String> converted = Arbre.tree2Arbre(rawTopo);
            Arbre<Taxon> converted2 = Taxon.LanguageUtils.convert(converted);
            return new RootedTreeImpl(converted2, bc.getBranchLengths(id));
        }

        public static RootedTree load(File pathToNewick) {
            BufferedReader reader = IOUtils.openInHard(pathToNewick);
            NewickParser np = new NewickParser(reader);
            try {
                RootedTreeImpl result;
                RootedTreeImpl rootedTreeImpl = result = new RootedTreeImpl(Taxon.LanguageUtils.convert(Arbre.tree2Arbre(np.parse())), np.getBranchLengths());
                return rootedTreeImpl;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException();
                }
            }
        }

        public static RootedTree fromNewickString(String newickStr) {
            NewickParser np = new NewickParser(newickStr);
            try {
                return new RootedTreeImpl(Taxon.LanguageUtils.convert(Arbre.tree2Arbre(np.parse())), np.getBranchLengths());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        public static double height(RootedTree rt) {
            double sum = 0.0;
            Arbre<Taxon> cur = rt.topology().leaves().iterator().next();
            while (!cur.isRoot()) {
                sum += rt.branchLengths().get(cur.getContents()).doubleValue();
                cur = cur.getParent();
            }
            return sum;
        }

        public static RootedTree random(Random rand, Collection<Taxon> leaves) {
            HashSet toMerge = CollUtils.set();
            for (Taxon leaf : leaves) {
                toMerge.add(Util.singleton(leaf));
            }
            int i = 0;
            while (toMerge.size() > 1) {
                ArrayList pair = CollUtils.list(Sampling.sampleSubset(rand, toMerge, 2));
                toMerge.removeAll(pair);
                double length0 = Sampling.sampleExponential(rand, 1.0);
                double length1 = Sampling.sampleExponential(rand, 1.0);
                Taxon internal = new Taxon("internal_" + i++);
                toMerge.add(Util.coalesce(internal, (RootedTree)pair.get(0), (RootedTree)pair.get(1), length0, length1));
            }
            return (RootedTree)CollUtils.pick(toMerge);
        }

        public static RootedTree singleton(Taxon t) {
            Arbre<Taxon> topo = Arbre.arbre(t);
            HashMap<Taxon, Double> bls = CollUtils.map();
            return Util.create(topo, bls);
        }

        public static RootedTree centroidRooting(UnrootedTree t) {
            UnorderedPair<Taxon, Taxon> edge = null;
            double min = Double.POSITIVE_INFINITY;
            for (UnorderedPair<Taxon, Taxon> e : t.edges()) {
                double cur = Util.sumHeights(t, e.getFirst()) + Util.sumHeights(t, e.getSecond());
                if (!(cur < min)) continue;
                edge = e;
                min = cur;
            }
            RootingInfo rooting = new RootingInfo((Taxon)edge.getFirst(), (Taxon)edge.getSecond(), new Taxon("root"), 0.5);
            return t.reRoot(rooting);
        }

        private static double sumHeights(UnrootedTree t, Taxon first) {
            double sum = 0.0;
            for (Taxon leaf : t.leaves()) {
                sum += t.totalBranchLengthDistance(leaf, first);
            }
            return sum;
        }

        public static class RootedTreeImpl
        implements RootedTree {
            private static final long serialVersionUID = 1L;
            private final Arbre<Taxon> topo;
            private final Map<Taxon, Double> bl;

            public RootedTreeImpl(Arbre<Taxon> topo, Map<Taxon, Double> bl) {
                this.topo = topo;
                this.bl = bl;
                if (bl.keySet().contains(topo.root().getContents())) {
                    throw new RuntimeException();
                }
                HashSet<Taxon> nodes = CollUtils.set(bl.keySet());
                nodes.add(topo.getContents());
                if (!nodes.equals(CollUtils.set(topo.nodeContents()))) {
                    throw new RuntimeException();
                }
            }

            @Override
            public Map<Taxon, Double> branchLengths() {
                return Collections.unmodifiableMap(this.bl);
            }

            @Override
            public Arbre<Taxon> topology() {
                return this.topo;
            }

            public String toString() {
                return Util.toString(this);
            }

            @Override
            public int nTaxa() {
                return this.topo.nLeaves();
            }

            @Override
            public RootedTree getRooted() {
                return this;
            }

            @Override
            public UnrootedTree getUnrooted() {
                return UnrootedTree.fromRooted(this);
            }
        }
    }

    public static interface RootedTreeProcessor {
        public void process(RootedTree var1);
    }

    public static class RootingInfo {
        public final Taxon l1;
        public final Taxon l2;
        public final Taxon root;
        public final double ratioToL1;

        public RootingInfo(Taxon l1, Taxon l2, Taxon root, double ratioToL1) {
            if (ratioToL1 < 0.0 || ratioToL1 > 1.0) {
                throw new RuntimeException();
            }
            this.l1 = l1;
            this.l2 = l2;
            this.root = root;
            this.ratioToL1 = ratioToL1;
        }

        public String toString() {
            return "(" + this.root + " (" + this.l1 + ":" + this.ratioToL1 + "x ...) (" + this.l2 + ":" + (1.0 - this.ratioToL1) + "x ...))";
        }
    }
}

