/*
 * Decompiled with CFR 0.152.
 */
package pty;

import conifer.Phylogeny;
import fig.basic.UnorderedPair;
import goblin.DataPrepUtils;
import goblin.Taxon;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ma.newick.NewickParser;
import ma.newick.ParseException;
import nuts.io.IO;
import nuts.math.Graph;
import nuts.math.Graphs;
import nuts.math.HashGraph;
import nuts.math.SemiGraph;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.Indexer;
import nuts.util.MathUtils;
import nuts.util.Tree;
import pty.RootedTree;
import pty.eval.SymmetricDiff;

public class UnrootedTree
implements Phylogeny {
    private static final long serialVersionUID = 1L;
    private final Graph<Taxon> topo;
    public final Map<UnorderedPair<Taxon, Taxon>, Double> branchLengths;

    public void changeBranchLength(UnorderedPair<Taxon, Taxon> edge, double newValue) {
        if (!this.branchLengths.containsKey(edge)) {
            throw new RuntimeException();
        }
        this.branchLengths.put(edge, newValue);
    }

    public Graph<Taxon> getTopology() {
        return this.topo;
    }

    public List<Taxon> leaves() {
        ArrayList<Taxon> result = new ArrayList<Taxon>();
        for (Taxon l : this.topo.vertexSet()) {
            if (this.topo.nbrs(l).size() != 1) continue;
            result.add(l);
        }
        return result;
    }

    public Set<Taxon> leavesSet() {
        return new HashSet<Taxon>(this.leaves());
    }

    public UnrootedTree(UnrootedTree model) {
        this.topo = model.topo;
        this.branchLengths = model.branchLengths;
    }

    public static UnrootedTree fromNewick(File path) {
        String treeDescr = IO.f2s(path);
        return UnrootedTree.fromNewick(treeDescr);
    }

    public static UnrootedTree fromNewickRemovingBinaryRoot(File f) {
        RootedTree t = RootedTree.Util.load(f);
        return UnrootedTree.fromRooted(t);
    }

    public static UnrootedTree fromNewickRemovingBinaryRoot(String stringContainingOneNewickFormattedTree) {
        RootedTree t = RootedTree.Util.fromNewickString(stringContainingOneNewickFormattedTree);
        return UnrootedTree.fromRooted(t);
    }

    public static UnrootedTree fromNewick(String stringContainingOneNewickFormattedTree) {
        try {
            NewickParser np = new NewickParser(stringContainingOneNewickFormattedTree);
            Arbre<String> t = Arbre.tree2Arbre(np.parse());
            Map<Taxon, Double> bl = np.getBranchLengths();
            HashMap<UnorderedPair<Taxon, Taxon>, Double> convertedBL = new HashMap<UnorderedPair<Taxon, Taxon>, Double>();
            HashSet<Taxon> vertices = new HashSet<Taxon>();
            HashSet edges = new HashSet();
            for (Arbre<String> node : t.nodes()) {
                Taxon current = new Taxon(node.getContents());
                vertices.add(current);
                if (node.isRoot()) continue;
                Taxon parent = new Taxon(node.getParent().getContents());
                UnorderedPair<Taxon, Taxon> key = new UnorderedPair<Taxon, Taxon>(current, parent);
                edges.add(key);
                convertedBL.put(key, bl.get(current));
            }
            return new UnrootedTree(new HashGraph<Taxon>(vertices, edges), convertedBL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static UnrootedTree fromRooted(RootedTree c) {
        HashMap<UnorderedPair<Taxon, Taxon>, Double> branchLengths = new HashMap<UnorderedPair<Taxon, Taxon>, Double>();
        HashSet<Taxon> languages = new HashSet<Taxon>(c.topology().nodeContents());
        HashSet edges = new HashSet();
        for (Arbre<Taxon> node : c.topology().nodes()) {
            if (node.isRoot()) continue;
            UnorderedPair<Taxon, Taxon> edge = null;
            double bl = -1.0;
            if (node.getParent().isRoot() && node.getParent().getChildren().size() == 2) {
                languages.remove(c.topology().getContents());
                List<Arbre<Taxon>> parentChildren = node.getParent().getChildren();
                edge = new UnorderedPair<Taxon, Taxon>(parentChildren.get(0).getContents(), parentChildren.get(1).getContents());
                bl = c.branchLengths().get(parentChildren.get(0).getContents()) + c.branchLengths().get(parentChildren.get(1).getContents());
            } else {
                edge = new UnorderedPair<Taxon, Taxon>(node.getContents(), node.getParent().getContents());
                bl = c.branchLengths().get(node.getContents());
            }
            edges.add(edge);
            branchLengths.put(edge, bl);
        }
        return new UnrootedTree(new HashGraph<Taxon>(languages, edges), branchLengths);
    }

    @Deprecated
    public Set<Set<Taxon>> clades() {
        Taxon internal = null;
        for (Taxon lang : this.topo.vertexSet()) {
            if (this.topo.nbrs(lang).size() <= 1) continue;
            internal = lang;
            break;
        }
        if (internal == null) {
            throw new RuntimeException();
        }
        return SymmetricDiff.cladesFromUnrooted(Arbre.tree2Arbre(Graphs.toTree(this.topo, internal)));
    }

    public Set<Set<Taxon>> unRootedClades() {
        HashSet<Set<Taxon>> result = CollUtils.set();
        for (UnorderedPair<Set<Taxon>, Set<Taxon>> bipart : this.inducedBiPartitions2BranchMap().keySet()) {
            result.add(bipart.getFirst());
            result.add(bipart.getSecond());
        }
        return result;
    }

    public Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> inducedBiPartitions2BranchMap() {
        Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> result = new Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>>();
        List<Taxon> allLeaves = this.leaves();
        Arbre<Taxon> topology = Arbre.tree2Arbre(Graphs.toTree(this.topo, allLeaves.get(0)));
        Map<Arbre<Taxon>, Set<Taxon>> leavesMap = Arbre.leavesMap(topology);
        for (Arbre<Taxon> key : leavesMap.keySet()) {
            if (key.isRoot()) continue;
            Set<Taxon> clade = leavesMap.get(key);
            double bl = this.branchLength(key.getContents(), key.getParent().getContents());
            HashSet<Taxon> complement = CollUtils.set(allLeaves);
            complement.removeAll(clade);
            result.setCount(new UnorderedPair<HashSet<Taxon>, Set<Taxon>>(complement, clade), bl);
        }
        return result;
    }

    public static double partitionMetric(UnrootedTree ut1, UnrootedTree ut2) {
        return UnrootedTree.partitionMetric(ut1, ut2, false, false);
    }

    public static double normalizedPartitionMetric(UnrootedTree ut1, UnrootedTree ut2, boolean useTightNormalizer) {
        return UnrootedTree.partitionMetric(ut1, ut2, true, useTightNormalizer);
    }

    public static double normalizedPartitionMetric(UnrootedTree ut1, UnrootedTree ut2) {
        return UnrootedTree.partitionMetric(ut1, ut2, true, false);
    }

    public static double tightlyNormalizedPartitionMetric(UnrootedTree ut1, UnrootedTree ut2) {
        return UnrootedTree.partitionMetric(ut1, ut2, true, true);
    }

    public static double partitionMetric(UnrootedTree ut1, UnrootedTree ut2, boolean normalize, boolean useTightNormalizer) {
        if (!ut1.leavesSet().equals(ut2.leavesSet())) {
            throw new RuntimeException();
        }
        Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> biparts1 = ut1.inducedBiPartitions2BranchMap();
        Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> biparts2 = ut2.inducedBiPartitions2BranchMap();
        for (UnorderedPair bipartition : CollUtils.union(biparts1.keySet(), biparts2.keySet())) {
            if (normalize && useTightNormalizer && (((Set)bipartition.getFirst()).size() <= 1 || ((Set)bipartition.getSecond()).size() <= 1)) {
                if (!biparts1.keySet().contains(bipartition) || !biparts2.keySet().contains(bipartition)) {
                    throw new RuntimeException();
                }
                biparts1.setCount(bipartition, 0.0);
                biparts2.setCount(bipartition, 0.0);
                continue;
            }
            if (biparts1.getCount(bipartition) != 0.0) {
                biparts1.setCount(bipartition, 1.0);
            }
            if (biparts2.getCount(bipartition) == 0.0) continue;
            biparts2.setCount(bipartition, 1.0);
        }
        return UnrootedTree.bipartitionMetric(biparts1, biparts2, true, normalize);
    }

    public static double robinsonFouldsMetric(UnrootedTree ut1, UnrootedTree ut2) {
        return UnrootedTree.robinsonFouldsMetric(ut1, ut2, false);
    }

    public static double normalizedRobinsonFouldsMetric(UnrootedTree ut1, UnrootedTree ut2) {
        return UnrootedTree.robinsonFouldsMetric(ut1, ut2, true);
    }

    public static double robinsonFouldsMetric(UnrootedTree ut1, UnrootedTree ut2, boolean normalize) {
        if (!ut1.leavesSet().equals(ut2.leavesSet())) {
            throw new RuntimeException();
        }
        Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> biparts1 = ut1.inducedBiPartitions2BranchMap();
        Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> biparts2 = ut2.inducedBiPartitions2BranchMap();
        return UnrootedTree.bipartitionMetric(biparts1, biparts2, true, normalize);
    }

    public static double kuhnerFelsenstein(UnrootedTree ut1, UnrootedTree ut2) {
        return UnrootedTree.kuhnerFelsenstein(ut1, ut2, false);
    }

    public static double normalizedKuhnerFelsenstein(UnrootedTree ut1, UnrootedTree ut2) {
        return UnrootedTree.kuhnerFelsenstein(ut1, ut2, true);
    }

    public static double kuhnerFelsenstein(UnrootedTree ut1, UnrootedTree ut2, boolean normalize) {
        if (!ut1.leavesSet().equals(ut2.leavesSet())) {
            throw new RuntimeException();
        }
        Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> biparts1 = ut1.inducedBiPartitions2BranchMap();
        Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> biparts2 = ut2.inducedBiPartitions2BranchMap();
        return UnrootedTree.bipartitionMetric(biparts1, biparts2, false, normalize);
    }

    private static double bipartitionMetric(Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> biparts1, Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> biparts2, boolean RF, boolean normalize) {
        IO.warnOnce("Fix bug (leaf branch lengths not taken into account");
        double n1 = 1.0;
        double n2 = 1.0;
        if (normalize) {
            n1 = biparts1.totalCount() * 2.0;
            n2 = biparts2.totalCount() * 2.0;
        }
        double sum = 0.0;
        for (UnorderedPair bipartition : CollUtils.union(biparts1.keySet(), biparts2.keySet())) {
            double b1 = biparts1.getCount(bipartition) / n1;
            double b2 = biparts2.getCount(bipartition) / n2;
            double diff = b1 - b2;
            sum += Math.abs(diff * (RF ? 1.0 : diff));
        }
        return sum;
    }

    public Counter<UnorderedPair<Taxon, Taxon>> pairwiseDistances() {
        Counter<UnorderedPair<Taxon, Taxon>> result = new Counter<UnorderedPair<Taxon, Taxon>>();
        List<Taxon> leaves = this.leaves();
        for (int i = 0; i < leaves.size(); ++i) {
            for (int j = i + 1; j < leaves.size(); ++j) {
                Taxon l1 = leaves.get(i);
                Taxon l2 = leaves.get(j);
                result.setCount(new UnorderedPair<Taxon, Taxon>(l1, l2), this.pairwiseDistance(l1, null, l2));
            }
        }
        return result;
    }

    private double pairwiseDistance(Taxon current, Taxon parent, Taxon target) {
        if (current.equals(target)) {
            return 0.0;
        }
        double min = Double.POSITIVE_INFINITY;
        for (Taxon nb : this.topo.nbrs(current)) {
            double recur;
            if (parent != null && nb.equals(parent) || Double.isInfinite(recur = this.pairwiseDistance(nb, current, target))) continue;
            return this.branchLength(nb, current) + recur;
        }
        return min;
    }

    public Tree<Taxon> toTree(Taxon aNode) {
        return Graphs.toTree(this.topo, aNode);
    }

    public Tree<Taxon> toTree() {
        return Graphs.toTree(this.topo, this.leaves().get(0));
    }

    public RootedTree reRootAtNode(Taxon t) {
        Arbre<Taxon> topo = Arbre.tree2Arbre(this.toTree(t));
        HashMap<Taxon, Double> branches = new HashMap<Taxon, Double>();
        for (Arbre<Taxon> subtree : topo.nodes()) {
            if (subtree.isRoot()) continue;
            branches.put(subtree.getContents(), this.branchLength(subtree.getContents(), subtree.getParent().getContents()));
        }
        return new RootedTree.Util.RootedTreeImpl(topo, branches);
    }

    public RootedTree reRootAtArbitraryInternalNode() {
        Taxon leaf = this.leaves().get(0);
        Set<Taxon> nbrs = this.topo.nbrs(leaf);
        if (nbrs.size() != 1) {
            throw new RuntimeException();
        }
        return this.reRootAtNode(CollUtils.pick(nbrs));
    }

    public RootedTree reRoot(RootedTree.RootingInfo rf) {
        return this.reRoot(rf.root, rf.l1, rf.l2, rf.ratioToL1);
    }

    private RootedTree reRoot(Taxon rootName, Taxon l1, Taxon l2, double ratioToL1) {
        if (!MathUtils.isCloseToProb(ratioToL1)) {
            throw new RuntimeException();
        }
        Tree<Taxon> tree = this.toTree(l1);
        Tree<Taxon> subt1 = new Tree<Taxon>(l1);
        Tree<Taxon> subt2 = null;
        for (Tree<Taxon> st : tree.getChildren()) {
            if (st.getLabel().equals(l2)) {
                subt2 = st;
                continue;
            }
            subt1.getChildren().add(st);
        }
        Tree<Taxon> fullTree = new Tree<Taxon>(rootName);
        fullTree.getChildren().add(subt1);
        if (subt2 == null) {
            return null;
        }
        fullTree.getChildren().add(subt2);
        Arbre<Taxon> a = Arbre.tree2Arbre(fullTree);
        HashMap<Taxon, Double> bls = CollUtils.map();
        for (Arbre<Taxon> sa : a.nodes()) {
            if (sa.isRoot()) continue;
            Taxon cur = sa.getContents();
            double val = Double.NaN;
            val = cur.equals(l1) ? ratioToL1 * this.branchLength(l1, l2) : (cur.equals(l2) ? (1.0 - ratioToL1) * this.branchLength(l1, l2) : this.branchLength(cur, sa.getParent().getContents()));
            bls.put(cur, val);
        }
        return RootedTree.Util.create(a, bls);
    }

    public String toNewick() {
        Tree<Taxon> t = Graphs.toTree(this.topo);
        return DataPrepUtils.newick2(t, this.branchLengths, false);
    }

    public String toNewick(Taxon root) {
        Tree<Taxon> t = Graphs.toTree(this.topo, root);
        return DataPrepUtils.newick2(t, this.branchLengths, false);
    }

    public List<UnorderedPair<Taxon, Taxon>> nbrEdges(UnorderedPair<Taxon, Taxon> edge) {
        ArrayList<UnorderedPair<Taxon, Taxon>> result = new ArrayList<UnorderedPair<Taxon, Taxon>>();
        for (Taxon lang : this.topo.nbrs(edge.getFirst())) {
            result.add(new UnorderedPair<Taxon, Taxon>(edge.getFirst(), lang));
        }
        for (Taxon lang : this.topo.nbrs(edge.getSecond())) {
            result.add(new UnorderedPair<Taxon, Taxon>(edge.getSecond(), lang));
        }
        return result;
    }

    public String toString() {
        Arbre<Taxon> a = Arbre.tree2Arbre(Graphs.toTree(this.topo));
        Arbre<String> annotated = a.preOrderMap(new Arbre.ArbreMap<Taxon, String>(){

            @Override
            public String map(Arbre<Taxon> currentDomainNode) {
                String result = currentDomainNode.getContents().toString();
                if (!currentDomainNode.isRoot()) {
                    result = result + ":" + UnrootedTree.this.branchLength(currentDomainNode.getContents(), currentDomainNode.getParent().getContents());
                }
                return result;
            }
        });
        return annotated.deepToString();
    }

    public static UnrootedTree normalize(UnrootedTree ut) {
        RootedTree rt = RootedTree.Util.centroidRooting(ut);
        rt = RootedTree.Util.normalizeBranches(rt);
        return UnrootedTree.fromRooted(rt);
    }

    public UnrootedTree(Graph<Taxon> topo, Map<UnorderedPair<Taxon, Taxon>, Double> branchLengths) {
        this.topo = topo;
        this.branchLengths = branchLengths;
    }

    public double branchLength(Taxon l1, Taxon l2) {
        return this.branchLength(new UnorderedPair<Taxon, Taxon>(l1, l2));
    }

    public double branchLength(UnorderedPair<Taxon, Taxon> edge) {
        return this.branchLengths.get(edge);
    }

    public Counter<UnorderedPair<Taxon, Taxon>> allTotalBranchLengthDistances() {
        return new EfficientUnrootedTree(this).allTotalBranchLengthDistances();
    }

    public double totalBranchLength() {
        double sum = 0.0;
        for (UnorderedPair<Taxon, Taxon> edge : this.edges()) {
            sum += this.branchLength(edge);
        }
        return sum;
    }

    public double totalBranchLengthDistance(Taxon l1, Taxon l2) {
        Tree<Taxon> t = this.toTree(l1);
        return this._totalBranchLengthDist(t, l2);
    }

    private double _totalBranchLengthDist(Tree<Taxon> t, Taxon target) {
        if (t.getLabel().equals(target)) {
            return 0.0;
        }
        double result = Double.POSITIVE_INFINITY;
        for (Tree<Taxon> child : t.getChildren()) {
            double cur = this._totalBranchLengthDist(child, target);
            if (Double.isInfinite(cur)) continue;
            if (!Double.isInfinite(result)) {
                throw new RuntimeException();
            }
            result = cur + this.branchLength(t.getLabel(), child.getLabel());
        }
        return result;
    }

    public UnorderedPair<Taxon, Taxon> randomEdge(Random rand) {
        return this.edges().get(rand.nextInt(this.edges().size()));
    }

    public UnorderedPair<Taxon, Taxon> randomNonTerminalEdge(Random rand) {
        if (this.nonTerminalEdges().size() == 0) {
            return null;
        }
        return this.nonTerminalEdges().get(rand.nextInt(this.nonTerminalEdges().size()));
    }

    public List<UnorderedPair<Taxon, Taxon>> edges() {
        return this._deterministic_edges();
    }

    private List<UnorderedPair<Taxon, Taxon>> _deterministic_edges() {
        ArrayList<UnorderedPair<Taxon, Taxon>> result = CollUtils.list();
        ArrayList<Taxon> taxa = CollUtils.list(this.topo.vertexSet());
        Collections.sort(taxa);
        for (Taxon t : taxa) {
            ArrayList<Taxon> nbs = CollUtils.list(this.topo.nbrs(t));
            Collections.sort(nbs);
            for (Taxon other : nbs) {
                if (other.compareTo(t) <= 0) continue;
                result.add(new UnorderedPair<Taxon, Taxon>(t, other));
            }
        }
        return result;
    }

    private List<UnorderedPair<Taxon, Taxon>> _non_deterministic_edges() {
        return new ArrayList<UnorderedPair<Taxon, Taxon>>(Graphs.edgeSet(this.topo));
    }

    public List<UnorderedPair<Taxon, Taxon>> nonTerminalEdges() {
        ArrayList<UnorderedPair<Taxon, Taxon>> nonTerminalEdge = null;
        if (nonTerminalEdge == null) {
            nonTerminalEdge = new ArrayList<UnorderedPair<Taxon, Taxon>>();
            for (UnorderedPair<Taxon, Taxon> edge : this.edges()) {
                if (this.topo.nbrs(edge.getFirst()).size() <= 1 || this.topo.nbrs(edge.getSecond()).size() <= 1) continue;
                nonTerminalEdge.add(edge);
            }
        }
        return nonTerminalEdge;
    }

    public static UnrootedTree removeZeroes(UnrootedTree ut) {
        double curLen;
        HashMap<UnorderedPair<Taxon, Taxon>, Double> bls = CollUtils.map();
        double minNotZero = Double.POSITIVE_INFINITY;
        for (UnorderedPair<Taxon, Taxon> bl : ut.branchLengths.keySet()) {
            curLen = ut.branchLengths.get(bl);
            if (!(curLen > 0.0) || !(curLen < minNotZero)) continue;
            minNotZero = curLen;
        }
        for (UnorderedPair<Taxon, Taxon> bl : ut.branchLengths.keySet()) {
            curLen = ut.branchLengths.get(bl);
            if (curLen == 0.0) {
                bls.put(bl, minNotZero / 2.0);
                continue;
            }
            bls.put(bl, curLen);
        }
        return new UnrootedTree(ut.topo, bls);
    }

    public UnrootedTree branchLengthNeighbor(UnorderedPair<Taxon, Taxon> edge, double newLength) {
        HashMap<UnorderedPair<Taxon, Taxon>, Double> branchLengthsCopy = new HashMap<UnorderedPair<Taxon, Taxon>, Double>(this.branchLengths);
        branchLengthsCopy.put(edge, newLength);
        return new UnrootedTree(this.topo, branchLengthsCopy);
    }

    public List<UnrootedTree> topologicalNeighbors(UnorderedPair<Taxon, Taxon> edge) {
        ArrayList<UnrootedTree> result = new ArrayList<UnrootedTree>();
        Taxon x = edge.getFirst();
        Taxon v = edge.getSecond();
        ArrayList<Taxon> xN = new ArrayList<Taxon>();
        ArrayList<Taxon> vN = new ArrayList<Taxon>();
        for (Taxon l : this.topo.nbrs(x)) {
            if (l == v) continue;
            xN.add(l);
        }
        for (Taxon l : this.topo.nbrs(v)) {
            if (l == x) continue;
            vN.add(l);
        }
        if (xN.size() != 2 || vN.size() != 2) {
            throw new RuntimeException("" + vN.size() + " or " + xN.size() + " vs. " + 2);
        }
        Taxon y = (Taxon)vN.get(0);
        Collections.sort(xN);
        for (Taxon z : xN) {
            result.add(this.neighborInterchange(v, x, y, z));
        }
        return result;
    }

    private UnrootedTree neighborInterchange(Taxon v, Taxon x, Taxon y, Taxon z) {
        final UnorderedPair<Taxon, Taxon> zx = new UnorderedPair<Taxon, Taxon>(z, x);
        final UnorderedPair<Taxon, Taxon> yv = new UnorderedPair<Taxon, Taxon>(y, v);
        final UnorderedPair<Taxon, Taxon> zv = new UnorderedPair<Taxon, Taxon>(z, v);
        final UnorderedPair<Taxon, Taxon> yx = new UnorderedPair<Taxon, Taxon>(y, x);
        HashGraph<Taxon> newTopo = new HashGraph<Taxon>(new SemiGraph<Taxon>(){

            @Override
            public boolean hasSemiEdge(Taxon one, Taxon two) {
                UnorderedPair<Taxon, Taxon> cur = new UnorderedPair<Taxon, Taxon>(one, two);
                if (cur.equals(zx) || cur.equals(yv)) {
                    return false;
                }
                if (cur.equals(zv) || cur.equals(yx)) {
                    return true;
                }
                return UnrootedTree.this.topo.hasEdge(one, two);
            }

            @Override
            public Set<Taxon> vertexSet() {
                return UnrootedTree.this.topo.vertexSet();
            }
        });
        HashMap<UnorderedPair<Taxon, Taxon>, Double> newBranches = new HashMap<UnorderedPair<Taxon, Taxon>, Double>();
        newBranches.put(yx, this.branchLengths.get(yv));
        newBranches.put(zv, this.branchLengths.get(zx));
        for (UnorderedPair<Taxon, Taxon> branch : this.branchLengths.keySet()) {
            if (branch.equals(zx) || branch.equals(yv)) continue;
            newBranches.put(branch, this.branchLengths.get(branch));
        }
        return new UnrootedTree(newTopo, newBranches);
    }

    public static UnrootedTree restrict(UnrootedTree t, Set<Taxon> leaves) {
        Counter<UnorderedPair<Taxon, Taxon>> originalDistances = t.allTotalBranchLengthDistances();
        Counter<UnorderedPair<Taxon, Taxon>> distances = new Counter<UnorderedPair<Taxon, Taxon>>();
        for (UnorderedPair<Taxon, Taxon> key : originalDistances.keySet()) {
            if (!leaves.contains(key.getFirst()) || !leaves.contains(key.getSecond())) continue;
            distances.setCount(key, originalDistances.getCount(key));
        }
        UnrootedTree result = null;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws ParseException, IOException {
        UnrootedTree temp = UnrootedTree.fromNewick(new File("e/575.exec/WALS-chain-0/mle.newick"));
        System.out.println("Original unrooted:\n" + temp);
        RootedTree.RootingInfo rt = new RootedTree.RootingInfo(new Taxon("internal_4"), new Taxon("internal_5"), new Taxon("root"), 0.5);
        RootedTree rootedTree = temp.reRoot(rt);
        System.out.println("Rerooted:\n" + rootedTree);
        RootedTree.RootingInfo t2 = RootedTree.Util.getRootingInfo(rootedTree);
        UnrootedTree temp2 = UnrootedTree.fromRooted(rootedTree);
        System.out.println("Rerooted again:\n" + temp2.reRoot(t2));
        temp = UnrootedTree.fromNewick(new File("e/575.exec/WALS-chain-0/mle.newick"));
        System.out.println(temp);
        System.out.println(temp.leaves().size());
        System.out.println("Size:" + temp.clades().size());
        for (Set set : temp.clades()) {
            System.out.println(set);
        }
        RootedTree c = RootedTree.Util.load(new File("data/toy-tree.newick"));
        UnrootedTree unrootedTree = UnrootedTree.fromRooted(c);
        System.out.println(unrootedTree);
        Random rand = new Random(1L);
        for (int i = 0; i < 10000; ++i) {
            void var3_7;
            UnorderedPair<Taxon, Taxon> edge = var3_7.randomEdge(rand);
            int newL = rand.nextInt(10);
            UnrootedTree unrootedTree2 = var3_7.branchLengthNeighbor(edge, newL);
            edge = unrootedTree2.randomNonTerminalEdge(rand);
            Iterator<UnrootedTree> iterator = unrootedTree2.topologicalNeighbors(edge).iterator();
            while (iterator.hasNext()) {
                UnrootedTree t3;
                UnrootedTree unrootedTree3 = t3 = iterator.next();
            }
        }
        System.out.println("done");
    }

    @Override
    public int nTaxa() {
        return this.leaves().size();
    }

    @Override
    public RootedTree getRooted() {
        return null;
    }

    @Override
    public UnrootedTree getUnrooted() {
        return this;
    }

    public static interface UnrootedTreeProcessor {
        public void process(UnrootedTree var1);
    }

    public static class EfficientUnrootedTree {
        private final int[][] nbhrs;
        private final double[][] bls;
        private final int nLeaves;
        private final Indexer<Taxon> indexer = new Indexer();

        public EfficientUnrootedTree(UnrootedTree ut) {
            List<Taxon> leaves = ut.leaves();
            this.nLeaves = leaves.size();
            for (Taxon leaf : leaves) {
                this.indexer.addToIndex((Taxon[])new Taxon[]{leaf});
            }
            for (Taxon node : ut.getTopology().vertexSet()) {
                if (this.indexer.containsObject(node)) continue;
                this.indexer.addToIndex((Taxon[])new Taxon[]{node});
            }
            int size = this.indexer.size();
            this.nbhrs = new int[size][];
            this.bls = new double[size][];
            for (Taxon t1 : ut.getTopology().vertexSet()) {
                int i1 = this.indexer.o2i(t1);
                Set<Taxon> curNbhrs = ut.topo.nbrs(t1);
                this.nbhrs[i1] = new int[curNbhrs.size()];
                this.bls[i1] = new double[curNbhrs.size()];
                int idx = 0;
                for (Taxon t2 : ut.getTopology().nbrs(t1)) {
                    int i2;
                    this.nbhrs[i1][idx] = i2 = this.indexer.o2i(t2);
                    this.bls[i1][idx] = ut.branchLength(t1, t2);
                    ++idx;
                }
            }
        }

        public Counter<UnorderedPair<Taxon, Taxon>> allTotalBranchLengthDistances() {
            double[][] result = new double[this.nLeaves][this.nLeaves];
            for (int start = 0; start < this.nLeaves - 1; ++start) {
                this._dfsTotalBL(0.0, start, start, -1, result);
            }
            Counter<UnorderedPair<Taxon, Taxon>> convertedResult = new Counter<UnorderedPair<Taxon, Taxon>>();
            for (int l1 = 0; l1 < this.nLeaves; ++l1) {
                Taxon t1 = this.indexer.i2o(l1);
                for (int l2 = l1 + 1; l2 < this.nLeaves; ++l2) {
                    convertedResult.setCount(new UnorderedPair<Taxon, Taxon>(t1, this.indexer.i2o(l2)), result[l1][l2]);
                }
            }
            return convertedResult;
        }

        private void _dfsTotalBL(double parentLen, int start, int current, int parent, double[][] result) {
            int[] thisNbhrs = this.nbhrs[current];
            double[] thisBLs = this.bls[current];
            if (thisNbhrs.length != thisBLs.length) {
                throw new RuntimeException();
            }
            for (int nIndex = 0; nIndex < thisNbhrs.length; ++nIndex) {
                int nbhr = thisNbhrs[nIndex];
                if (nbhr == parent) continue;
                double newLen = parentLen + thisBLs[nIndex];
                if (nbhr < this.nLeaves) {
                    result[start][nbhr] = newLen;
                    continue;
                }
                this._dfsTotalBL(newLen, start, nbhr, current, result);
            }
        }
    }
}

