/*
 * Decompiled with CFR 0.152.
 */
package pty.io;

import fig.basic.Pair;
import goblin.Taxon;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.util.CollUtils;
import pty.io.WalsDataset;

public class WalsProcessingScript {
    public Set<String> languageFamiliesToIgnore = CollUtils.set();
    public Set<String> featuresToIgnore = CollUtils.set();
    public Map<String, List<List<Integer>>> characterTranslations = CollUtils.map();
    public Set<String> orderFeature = CollUtils.set();
    public static final Pattern mapCmdPattern = Pattern.compile("\\s*[>]MAP[-]CHARACTERS[(]([^)]*)[)].*");
    public static final Pattern cmdPattern = Pattern.compile("\\s*[>](.*)");
    public static final Pattern featurePattern = Pattern.compile("\\s*(\\S.*\\S)\\s*");
    public Map<Pair<WalsDataset.Site, WalsDataset.BioCharacter>, List<Pair<WalsDataset.Site, WalsDataset.BioCharacter>>> cache = CollUtils.map();

    public WalsProcessingScript(File file) {
        Mode currentMode = null;
        List<List<Integer>> currentArgs = null;
        for (String line : IO.i(file)) {
            if (mapCmdPattern.matcher(line = line.replaceAll("[#].*", "")).matches()) {
                currentMode = Mode.MAPCHAR;
                currentArgs = this.parseMapArgs(StringUtils.selectFirstRegex(mapCmdPattern, line));
                continue;
            }
            if (cmdPattern.matcher(line).matches()) {
                String parsedCmdName = StringUtils.selectFirstRegex(cmdPattern, line);
                if (parsedCmdName.equals("IGNORE-LANGUAGE-FAMILY")) {
                    currentMode = Mode.IGLAN;
                    continue;
                }
                if (parsedCmdName.equals("IGNORE-FEATURE")) {
                    currentMode = Mode.IGFEAT;
                    continue;
                }
                if (parsedCmdName.equals("ORDER-FEATURE")) {
                    currentMode = Mode.ORDER;
                    continue;
                }
                throw new RuntimeException();
            }
            if (featurePattern.matcher(line).matches()) {
                String feature = StringUtils.selectFirstRegex(featurePattern, line);
                if (currentMode == Mode.MAPCHAR) {
                    this.characterTranslations.put(feature, currentArgs);
                    continue;
                }
                if (currentMode == Mode.IGFEAT) {
                    this.featuresToIgnore.add(feature);
                    continue;
                }
                if (currentMode == Mode.ORDER) {
                    this.orderFeature.add(feature);
                    continue;
                }
                if (currentMode == Mode.IGLAN) {
                    this.languageFamiliesToIgnore.add(feature);
                    continue;
                }
                throw new RuntimeException();
            }
            if (line.matches("\\s*")) continue;
            throw new RuntimeException();
        }
    }

    private List<List<Integer>> parseMapArgs(String str) {
        String[] splitCol = str.split(";");
        ArrayList<List<Integer>> result = CollUtils.list();
        for (String subStr : splitCol) {
            ArrayList current = CollUtils.list();
            for (String atom : subStr.split(",")) {
                current.add(Integer.parseInt(atom.replaceAll("\\s", "")));
            }
            result.add(current);
        }
        return result;
    }

    public boolean ignore(Taxon t) {
        String family = WalsDataset.langDB.familyMap().get(t);
        return this.languageFamiliesToIgnore.contains(family);
    }

    public boolean ignore(WalsDataset.Site feature) {
        return this.featuresToIgnore.contains(feature.toString());
    }

    public boolean shouldTranslate(WalsDataset.Site site) {
        return this.characterTranslations.keySet().contains(site.toString());
    }

    public List<Pair<WalsDataset.Site, WalsDataset.BioCharacter>> translate(Pair<WalsDataset.Site, WalsDataset.BioCharacter> item) {
        if (!this.cache.keySet().contains(item)) {
            WalsDataset.Site site = item.getFirst();
            List<List<Integer>> map = this.characterTranslations.get(site.toString());
            WalsDataset.BioCharacter bioChar = item.getSecond();
            List<Integer> translation = map.get(bioChar.index);
            ArrayList result = CollUtils.list();
            for (int newSiteIdx = 0; newSiteIdx < translation.size(); ++newSiteIdx) {
                result.add(Pair.makePair(new WalsDataset.Site(site.toString() + "(" + newSiteIdx + ")"), new WalsDataset.BioCharacter("" + translation.get(newSiteIdx))));
            }
            this.cache.put(item, result);
        }
        return this.cache.get(item);
    }

    public static enum Mode {
        MAPCHAR,
        IGFEAT,
        IGLAN,
        ORDER;

    }
}

