/*
 * Decompiled with CFR 0.152.
 */
package pty.smc;

import fig.basic.Option;
import fig.basic.Pair;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import pty.io.Dataset;
import pty.smc.LazyPCS;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleKernel;
import pty.smc.models.CTMC;

public class LazyPriorPrior
implements ParticleKernel<LazyPCS> {
    @Option
    public static boolean insureLastStepNoRootResampling = true;
    @Option
    public static LazyProposalType proposalType = LazyProposalType.COAL;
    @Option
    public static LazyProposalType priorType = LazyProposalType.COAL;
    private static final double uniformMax = 1.0;
    private final DeltaDistribution q = proposalType.getInstance();
    private final DeltaDistribution prior = priorType.getInstance();
    private final LazyPCS initial;
    private static Dataset dataset = null;
    private static CTMC ctmc;

    public LazyPriorPrior(PartialCoalescentState initial) {
        this.initial = new LazyPCS(initial);
    }

    @Override
    public LazyPCS getInitial() {
        return this.initial;
    }

    @Override
    public int nIterationsLeft(LazyPCS partialState) {
        return partialState.nIterationsLeft();
    }

    @Override
    public Pair<LazyPCS, Double> next(Random rand, LazyPCS _current) {
        PartialCoalescentState current = _current.getState();
        double delta = this.q.sampleDelta(current, rand);
        List<Integer> sampledIndices = Sampling.sampleWithoutReplacement(rand, current.nRoots(), 2);
        if (sampledIndices.size() != 2) {
            throw new RuntimeException();
        }
        int i0 = sampledIndices.get(0);
        int i1 = sampledIndices.get(1);
        double p = current.peekLogLikelihoodRatio(i0, i1, delta, 0.0, 0.0);
        double logWeightUpdate = p + this.prior.deltaLogDensity(current, delta) - this.q.deltaLogDensity(current, delta);
        return Pair.makePair(new LazyPCS(current, delta, i0, i1), logWeightUpdate);
    }

    public static double nChoose2(double n) {
        return n * (n - 1.0) / 2.0;
    }

    public static class YuleDeltaDistribution
    implements DeltaDistribution {
        @Override
        public double deltaLogDensity(PartialCoalescentState current, double delta) {
            return Sampling.exponentialLogDensity(1.0 / (double)current.nRoots(), delta);
        }

        @Override
        public double sampleDelta(PartialCoalescentState current, Random rand) {
            return Sampling.sampleExponential(rand, 1.0 / (double)current.nRoots());
        }
    }

    public static class UniformDeltaDistribution
    implements DeltaDistribution {
        @Override
        public double deltaLogDensity(PartialCoalescentState current, double delta) {
            return Math.log(1.0);
        }

        @Override
        public double sampleDelta(PartialCoalescentState current, Random rand) {
            return Sampling.nextDouble(rand, 0.0, 1.0);
        }
    }

    public static class CoalescentDeltaDistribution
    implements DeltaDistribution {
        @Override
        public double deltaLogDensity(PartialCoalescentState current, double delta) {
            return Sampling.exponentialLogDensity(1.0 / LazyPriorPrior.nChoose2(current.nRoots()), delta);
        }

        @Override
        public double sampleDelta(PartialCoalescentState current, Random rand) {
            return Sampling.sampleExponential(rand, 1.0 / LazyPriorPrior.nChoose2(current.nRoots()));
        }
    }

    public static interface DeltaDistribution {
        public double sampleDelta(PartialCoalescentState var1, Random var2);

        public double deltaLogDensity(PartialCoalescentState var1, double var2);
    }

    public static enum LazyProposalType {
        UNIF{

            @Override
            public DeltaDistribution getInstance() {
                return new UniformDeltaDistribution();
            }
        }
        ,
        YULE{

            @Override
            public DeltaDistribution getInstance() {
                return new YuleDeltaDistribution();
            }
        }
        ,
        COAL{

            @Override
            public DeltaDistribution getInstance() {
                return new CoalescentDeltaDistribution();
            }
        };


        public abstract DeltaDistribution getInstance();
    }
}

