/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.test;

import fig.basic.Option;
import fig.exec.Execution;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.math.GMFct;
import nuts.util.Arbre;
import nuts.util.Counter;
import pty.io.Dataset;
import pty.io.HGDPDataset;
import pty.learn.DiscreteBP;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import pty.smc.PriorPostKernel;
import pty.smc.PriorPriorKernel;
import pty.smc.models.CTMC;

public class Impute
implements Runnable {
    @Option
    public String filename;
    @Option
    boolean usePriorPost = true;
    public static final int N = 5;
    public static final Random rand = new Random(1L);
    public static int[][] observations;
    public static ArrayList<Taxon> leafNames;
    public static int nleaves;
    public static int nsites;

    public static void main(String[] args) {
        Execution.run(args, new Impute(), "hgdp", HGDPDataset.class);
    }

    public static PartialCoalescentState initCTMCGeneState() {
        Dataset data = Dataset.DatasetType.HGDP.loadDataset();
        int nsites = data.nSites();
        double rateScalar = 1.0E-8;
        double[][] rate = new double[][]{{-rateScalar, rateScalar}, {rateScalar, -rateScalar}};
        CTMC.SimpleCTMC ctmc = new CTMC.SimpleCTMC(rate, nsites);
        return PartialCoalescentState.initState(data, ctmc);
    }

    @Override
    public void run() {
        PartialCoalescentState pcs = Impute.initCTMCGeneState();
        ParticleKernel<PartialCoalescentState> ppk = this.usePriorPost ? new PriorPostKernel(pcs) : new PriorPriorKernel(pcs);
        ParticleFilter.ParticleMapperProcessor<PartialCoalescentState, PartialCoalescentState> mapd = ParticleFilter.ParticleMapperProcessor.saveCoalescentParticlesProcessor();
        ParticleFilter.bootstrapFilter(ppk, mapd, 5, rand);
        ArrayList<Counter<String>> marginalProbabilities = new ArrayList<Counter<String>>();
        for (int i = 0; i < nsites; ++i) {
            marginalProbabilities.add(new Counter());
        }
        int count = 0;
        for (PartialCoalescentState p : mapd.getCounter().keySet()) {
            System.out.println("Processing tree " + count++);
            Arbre<Taxon> tree = p.getArbreAndBranchLengths().getFirst();
            List<Arbre<Taxon>> leaves = tree.getLeaves();
            for (int i = 0; i < nsites; ++i) {
                GMFct<Taxon> gmf = DiscreteBP.posteriorMarginalTransitions(p, i);
                Counter<String> probCounter = marginalProbabilities.get(i);
                for (Arbre<Taxon> l : leaves) {
                    probCounter.incrementCount(l.toString(), gmf.get(l.getContents(), 1));
                }
            }
        }
        this.fillIn(marginalProbabilities);
    }

    public void fillIn(ArrayList<Counter<String>> marginalProbabilities) {
        for (int i = 0; i < nleaves; ++i) {
            System.out.print(leafNames.get(i) + "\t");
            for (int j = 0; j < nsites; ++j) {
                Counter<String> probCounter = marginalProbabilities.get(j);
                if (observations[i][j] == -1) {
                    double prob = probCounter.getCount(leafNames.get(i).toString());
                    int filledin = rand.nextDouble() < prob ? 1 : 0;
                    System.out.print(filledin + "\t");
                    continue;
                }
                System.out.print(observations[i][j] + "\t");
            }
            System.out.print("\n");
        }
    }
}

