/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.test;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import goblin.Taxon;
import java.util.Set;
import nuts.util.CollUtils;
import nuts.util.Counter;
import pty.eval.SymmetricDiff;
import pty.io.HGDPDataset;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import pty.smc.PriorPriorKernel;
import pty.smc.test.SymmetryTest;
import pty.smc.test.TestBrownianModel;

public class TestKernelsAgreement
implements Runnable {
    @Option
    public static double firstKernelNIterationFactor = 1.0;
    @Option
    public static TestBrownianModel.KernelType kernel1 = TestBrownianModel.KernelType.PRIOR_PRIOR;
    @Option
    public static TestBrownianModel.KernelType kernel2 = TestBrownianModel.KernelType.PRIOR_POST;
    @Option
    public static int baseN = 100;
    @Option
    public static int maxN = 100000;
    @Option
    public static int addToN = 0;
    @Option
    public static double multiplyToN = 2.0;
    @Option
    public static double variance = 1.5E-5;
    @Option
    public static boolean onlyOne = false;
    public static ParticleFilter<PartialCoalescentState> pf = new ParticleFilter();

    public static void main(String[] args) {
        Execution.monitor = true;
        Execution.makeThunk = false;
        Execution.create = true;
        Execution.useStandardExecPoolDirStrategy = true;
        Execution.run(args, new TestKernelsAgreement(), "pf", pf, "hgdp", HGDPDataset.class, "pcs", PartialCoalescentState.class, "ppk", PriorPriorKernel.class);
    }

    @Override
    public void run() {
        PartialCoalescentState initGeneState = TestBrownianModel.initGeneState(variance);
        ParticleKernel<PartialCoalescentState> ppk1 = kernel1.load(initGeneState, null);
        ParticleKernel<PartialCoalescentState> ppk2 = kernel2.load(initGeneState, null);
        int N2 = baseN;
        while (N2 < maxN) {
            LogInfo.logs("N=" + N2);
            ParticleFilter.ParticleMapperProcessor<PartialCoalescentState, Set<Set<Taxon>>> mbr1 = SymmetricDiff.createCladeProcessor();
            ParticleFilter.ParticleMapperProcessor<PartialCoalescentState, Set<Set<Taxon>>> mbr2 = SymmetricDiff.createCladeProcessor();
            SymmetryTest.MeanHeight mh1 = new SymmetryTest.MeanHeight();
            SymmetryTest.MeanHeight mh2 = new SymmetryTest.MeanHeight();
            ParticleFilter.ForkedProcessor fp1 = new ParticleFilter.ForkedProcessor(mbr1, mh1);
            ParticleFilter.ForkedProcessor fp2 = new ParticleFilter.ForkedProcessor(mbr2, mh2);
            TestKernelsAgreement.pf.N = (int)((double)N2 * firstKernelNIterationFactor);
            pf.sample(ppk1, fp1);
            if (!onlyOne) {
                TestKernelsAgreement.pf.N = N2;
                pf.sample(ppk2, fp2);
            }
            LogInfo.logs(TestKernelsAgreement.diff(mbr1.getCounter(), mbr2.getCounter()));
            LogInfo.logs("\nHeight\t" + mh1.ss.getSum() + "\t" + mh2.ss.getSum());
            N2 = (int)(multiplyToN * (double)N2 + (double)addToN);
        }
    }

    public static String diff(Counter c1, Counter c2) {
        Counter<Object> c = new Counter<Object>();
        for (Object o : CollUtils.union(c1.keySet(), c2.keySet())) {
            c.setCount(o, Math.abs(c1.getCount(o) - c2.getCount(o)));
        }
        StringBuilder result = new StringBuilder();
        for (Object e : c) {
            result.append(e + "\t" + c1.getCount(e) + "\t" + c2.getCount(e) + "\t" + c.getCount(e) + "\n");
        }
        return result.toString();
    }
}

