/*
 * Decompiled with CFR 0.152.
 */
package sand;

import fig.prob.SampleUtils;
import java.util.Random;
import nuts.util.MathUtils;
import sand.TransitionKernel;

public class PoissonKernel
implements TransitionKernel {
    public static double rateMultiplier = 0.2;
    public static double rateAdd = 2.0;

    @Override
    public int nCurrentStates() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int nNextStates() {
        return Integer.MAX_VALUE;
    }

    @Override
    public double pr(int currentState, int nextState) {
        return MathUtils.poisson(this.rate(currentState), nextState);
    }

    public double rate(int currentState) {
        return rateMultiplier * (double)currentState + rateAdd;
    }

    @Override
    public int sample(int currentState, Random rand) {
        return (int)SampleUtils.samplePoisson(rand, this.rate(currentState));
    }
}

