/*
 * Decompiled with CFR 0.152.
 */
package sand;

import java.util.Random;
import nuts.tui.Table;
import sand.ObservedEmissionKernel;
import sand.PoissonKernel;
import sand.SandwitchSampler;
import sand.TransitionKernel;
import sand.TruncatedKernel;

public class PoissonTest {
    public static int length = 5;
    public static final int truncation = 20;
    public static final TransitionKernel kernel = new TruncatedKernel(new PoissonKernel(), 20);
    public static final Random rand = new Random(1L);
    public int[] hiddenStates;
    public int[] observations;
    public static boolean useSecondOrder;

    public void generate() {
        this.hiddenStates = new int[length];
        this.observations = new int[length];
        this.hiddenStates[0] = 0;
        this.observations[0] = kernel.sample(1, rand);
        for (int i = 1; i < length; ++i) {
            this.hiddenStates[i] = kernel.sample(this.hiddenStates[i - 1], rand);
            this.observations[i] = kernel.sample(this.hiddenStates[i], rand);
        }
    }

    public Table toTable() {
        Table table = new Table(new Table.Populator(){

            @Override
            public void populate() {
                this.set(0, 0, PoissonTest.this.hiddenStates[0]);
                this.set(1, 0, "|");
                this.set(2, 0, PoissonTest.this.observations[0]);
                for (int t = 1; t < length; ++t) {
                    this.set(0, 2 * t - 1, "--");
                    this.set(0, 2 * t, PoissonTest.this.hiddenStates[t]);
                    this.set(1, 2 * t, "|");
                    this.set(2, 2 * t, PoissonTest.this.observations[t]);
                }
            }
        });
        table.setBorder(false);
        return table;
    }

    public String toString() {
        return this.toTable().toString();
    }

    public SandwitchSampler createSampler() {
        ObservedEmissionKernel[] observeds = new Observed[length];
        TransitionKernel[] transition = new TransitionKernel[length];
        for (int t = 0; t < length; ++t) {
            observeds[t] = new Observed(t);
            transition[t] = new TruncatedKernel(new PoissonKernel(), 20);
        }
        return new SandwitchSampler(transition, observeds, 1.0E-8, useSecondOrder);
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            System.err.println("[n iters] [len of chain] [rate add] [rate mult] [use2ndOrder]");
            return;
        }
        useSecondOrder = Boolean.parseBoolean(args[4]);
        length = Integer.parseInt(args[1]);
        PoissonKernel.rateAdd = Double.parseDouble(args[2]);
        PoissonKernel.rateMultiplier = Double.parseDouble(args[3]);
        PoissonTest test = new PoissonTest();
        double nSamples = Integer.parseInt(args[0]);
        double sum = 0.0;
        double denom = 0.0;
        int i = 0;
        while ((double)i < nSamples) {
            test.generate();
            System.out.println(test.toString());
            SandwitchSampler sampler = test.createSampler();
            int[] sample = sampler.sample(rand).getLegacyHMMHiddenStates();
            for (int j = 1; j < sample.length; ++j) {
                if ((double)sample[j - 1] == 0.0) continue;
                denom += 1.0;
                sum += ((double)sample[j] - PoissonKernel.rateAdd) / (double)sample[j - 1];
            }
            ++i;
        }
        System.out.println("Result: " + sum / denom);
    }

    public static double estimateMult(int[] sample) {
        double sum = 0.0;
        double denom = 0.0;
        for (int i = 1; i < sample.length; ++i) {
            if ((double)sample[i - 1] == 0.0) continue;
            denom += 1.0;
            sum += ((double)sample[i] - PoissonKernel.rateAdd) / (double)sample[i - 1];
        }
        return sum / denom;
    }

    public class Observed
    implements ObservedEmissionKernel {
        private final int t;

        public Observed(int t) {
            this.t = t;
        }

        @Override
        public int nStates() {
            return kernel.nCurrentStates();
        }

        @Override
        public double pr(int state) {
            return kernel.pr(state, PoissonTest.this.observations[this.t]);
        }
    }
}

