/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.util.Random;
import nuts.math.Fct;
import nuts.math.MCIntegrator;
import nuts.math.Sampler;
import nuts.math.Sampling;

public class MCTest {
    public static Fct<double[], Double> test = new Fct<double[], Double>(){

        @Override
        public Double evalAt(double[] x) {
            return x[0];
        }
    };
    public static Fct<double[], Double> left = new Fct<double[], Double>(){

        @Override
        public Double evalAt(double[] x) {
            double num = Sampling.exponentialDensity(means[0], x[0]);
            double denom = Sampling.exponentialDensity(means[1], x[0]);
            return num / denom;
        }
    };
    public static Fct<double[], Double> right = new Fct<double[], Double>(){

        @Override
        public Double evalAt(double[] x) {
            double num = Sampling.exponentialDensity(means[0], x[0]);
            double denom = Sampling.exponentialDensity(means[1], x[1]);
            return num / denom;
        }
    };
    public static final double[] means = new double[]{1.5, 1.4};
    public static Sampler<double[]> sampler = new Sampler<double[]>(){
        public final Random rand = new Random(1L);

        @Override
        public double[] sample() {
            double[] result = new double[means.length];
            for (int i = 0; i < means.length; ++i) {
                result[i] = Sampling.sampleExponential(this.rand, means[i]);
            }
            return result;
        }

        @Override
        public double previousSampleWeigth() {
            return 1.0;
        }
    };

    public static void main(String[] args) {
        MCIntegrator<double[]> integrator = new MCIntegrator<double[]>(sampler);
        integrator.setIterations(10000000);
        System.out.println("Var test = " + MCTest.variance(test, integrator));
        System.out.println("Var of left = " + MCTest.variance(left, integrator));
        System.out.println("Var of right = " + MCTest.variance(right, integrator));
    }

    public static <T> double variance(Fct<T, Double> f, MCIntegrator<T> integrator) {
        double expectation = integrator.integrate(f);
        Sqr sqr = new Sqr(f);
        double expectationOfSqr = integrator.integrate(sqr);
        return expectationOfSqr - expectation * expectation;
    }

    public static class Sqr<T>
    implements Fct<T, Double> {
        public final Fct<T, Double> input;

        private Sqr(Fct<T, Double> input) {
            this.input = input;
        }

        @Override
        public Double evalAt(T x) {
            double before = this.input.evalAt(x);
            return before * before;
        }
    }
}

