/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import nuts.io.IO;
import nuts.lang.StringUtils;

public class ParseMacros {
    public static final String bs = "\\\\";
    public static final Pattern newcommand = Pattern.compile(".*\\\\(def|newcommand|DeclareMathOperator)[*]?[{]?\\\\([0-9A-Za-z]+)[}]?(\\[[0-9]+\\])?([{][^%]+)([%].*)?$");

    public static void main(String[] args) {
        HashSet<String> names = new HashSet<String>();
        System.out.println("<script src=\"sorttable.js\"></script>");
        System.out.println("<style type=\"text/css\"> th, td {  padding: 3px !important;}/* Sortable tables */table.sortable thead {    background-color:#eee;    color:#666666;    font-weight: bold;    cursor: default;}</style>");
        System.out.println("<table class=\"sortable\">");
        System.out.println("<tr><th>Name</th><th>Comments</th><th>Type</th><th>#Args</th><th>Definition</th><th>Source file</th><th>Line#</th><th>Duplicate?</th></tr>");
        TreeSet<String> sorted = new TreeSet<String>();
        for (String arg : args) {
            int lineNumber = 0;
            for (String line : IO.i(arg)) {
                if (newcommand.matcher(line).matches()) {
                    String cur = "<tr>";
                    Macro current = new Macro(StringUtils.multiSelectFirstRegex(newcommand, line), arg, lineNumber);
                    boolean duplicate = names.contains(current.name);
                    cur = cur + current.toString() + "<td>" + (duplicate ? "YES" : "no") + "</td>";
                    cur = cur + "</tr>";
                    names.add(current.name);
                    sorted.add(cur);
                }
                ++lineNumber;
            }
        }
        for (String s : sorted) {
            System.out.println(s);
        }
        System.out.println("</table>");
    }

    public static class Macro {
        public final String type;
        public final String name;
        public final String nArgs;
        public final String defn;
        public final String comments;
        public final String sourceFile;
        public final String lineNumber;

        public Macro(List<String> parsed, String file, int line) {
            this.type = parsed.get(0);
            this.name = parsed.get(1);
            this.nArgs = parsed.get(2) == null ? "0" : parsed.get(2).replaceAll("\\]", "").replaceAll("\\[", "");
            String rawDef = parsed.get(3).replaceAll("\\s*$", "");
            try {
                if (StringUtils.selectRegex("([{])", rawDef).size() != StringUtils.selectRegex("([}])", rawDef).size()) {
                    rawDef = rawDef + "...";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.defn = rawDef;
            String rawComments = parsed.get(4);
            this.comments = rawComments == null ? "" : rawComments.replaceFirst("[%]\\s*", "");
            this.sourceFile = file;
            this.lineNumber = "" + line;
        }

        public String toString() {
            return "<td>" + this.name + "</td><td>" + this.comments + "</td><td>" + this.type + "</td><td>" + this.nArgs + "</td><td>" + this.defn + "</td><td>" + this.sourceFile + "</td><td>" + this.lineNumber + "</td>";
        }
    }
}

