/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.util.Random;
import nuts.math.Sampling;

public class SimpleMCMC {
    public static void main(String[] args) {
        Random rand = new Random(1L);
        double proposalParam = 1.0;
        double num = 0.0;
        double denom = 0.0;
        double currentT = 1.0;
        for (int i = 0; i < 1000000; ++i) {
            double proposedValue = Sampling.sampleExponential(rand, 1.0);
            double propLogDensity = Sampling.exponentialLogDensity(1.0, proposedValue);
            double backPropLogDensity = Sampling.exponentialLogDensity(1.0, currentT);
            double newDensity = SimpleMCMC.logF(proposedValue);
            double currentDensity = SimpleMCMC.logF(currentT);
            double ratio = Sampling.min1exp(newDensity - currentDensity + backPropLogDensity - propLogDensity);
            if (rand.nextDouble() < ratio) {
                currentT = proposedValue;
            }
            num += currentT;
            denom += 1.0;
            if (i % 1000 != 0) continue;
            System.out.println("" + i + "\t" + num / denom);
        }
    }

    public static double logF(double t) {
        return -0.5 * t + Math.log(1.0 - Math.exp(-2.0 * t / 3.0));
    }
}

