/*
 * Decompiled with CFR 0.152.
 */
package sgi;

import fig.basic.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import nuts.io.IO;
import nuts.io.IteratorWrapper;
import nuts.util.Indexer;
import nuts.util.Tree;
import nuts.util.Trees;
import sgi.HierarchicalAligner;
import sgi.ScoreFct;

public class Main {
    public static Random rand = new Random(1L);

    public static Iterator<Tree<String>> readTrees(String fileName) throws IOException {
        BufferedReader in = IOUtils.openIn(fileName);
        Trees.PennTreeReader treeReader = new Trees.PennTreeReader(in);
        return treeReader;
    }

    public static int nTrees(String file) throws IOException {
        Iterator<Tree<String>> trees = Main.readTrees(file);
        int result = 0;
        for (Tree<String> tree : IteratorWrapper.IW(trees)) {
            ++result;
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        String file1 = args[0];
        String file2 = args[1];
        if (Main.nTrees(file1) != Main.nTrees(file2)) {
            System.err.println("" + Main.nTrees(file1) + " not equal to " + Main.nTrees(file2));
            return;
        }
        Iterator<Tree<String>> zhTrees = Main.readTrees(file1);
        Iterator<Tree<String>> enTrees = Main.readTrees(file2);
        Indexer<String> nonTermIndexer = new Indexer<String>();
        Indexer<String> termIndexer = new Indexer<String>();
        ArrayList<Datum> data = new ArrayList<Datum>();
        while (zhTrees.hasNext()) {
            Tree<String> t1 = zhTrees.next();
            Tree<String> t2 = enTrees.next();
            System.out.print(".");
            Datum datum = new Datum();
            datum.t1 = t1;
            datum.t2 = t2;
            data.add(datum);
            Main.addToIndexer(t1, nonTermIndexer, termIndexer);
        }
        System.out.println("Index sizes:" + nonTermIndexer.size() + "," + termIndexer.size());
        if (enTrees.hasNext()) {
            throw new RuntimeException();
        }
        ScoreFct.CollapsedDPScoreFct scoreFct = new ScoreFct.CollapsedDPScoreFct(termIndexer, nonTermIndexer);
        for (int i = 0; i < 10; ++i) {
            Collections.shuffle(data, rand);
            for (Datum datum : data) {
                scoreFct.update(datum.ruleMatch, -1.0);
                try {
                    int s1 = datum.t1.getPostOrderTraversal().size();
                    int s2 = datum.t2.getPostOrderTraversal().size();
                    if (Math.max(s1, s2) > 100) continue;
                    IO.so("tree sizes:" + s1 + "," + s2);
                    HierarchicalAligner sampler = new HierarchicalAligner(datum.t1, datum.t2, scoreFct);
                    datum.ruleMatch = sampler.sample(Main.rand);
                    IO.so(datum.ruleMatch.toString());
                    scoreFct.update(datum.ruleMatch, 1.0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void addToIndexer(Tree<String> t1, Indexer<String> nonTermIndexer, Indexer<String> termIndexer) {
        String obj = t1.getLabel();
        if (t1.isLeaf()) {
            termIndexer.addToIndex((String[])new String[]{obj});
            return;
        }
        nonTermIndexer.addToIndex((String[])new String[]{obj});
        for (Tree<String> child : t1.getChildren()) {
            Main.addToIndexer(child, nonTermIndexer, termIndexer);
        }
    }

    public static class Datum {
        private Tree<String> t1;
        private Tree<String> t2;
        private List<HierarchicalAligner.RuleMatch> ruleMatch = new ArrayList<HierarchicalAligner.RuleMatch>();
    }
}

