/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;

public class VirtualFolder
implements SpoonFolder {
    private final Set<SpoonFile> files = new HashSet<SpoonFile>();
    private final Set<SpoonFolder> folders = new HashSet<SpoonFolder>();

    @Override
    public void addFile(SpoonFile o) {
        this.files.add(o);
    }

    @Override
    public void addFolder(SpoonFolder o) {
        this.folders.add(o);
    }

    @Override
    public List<SpoonFile> getAllFiles() {
        ArrayList<SpoonFile> result = new ArrayList<SpoonFile>();
        for (SpoonFolder spoonFolder : this.folders) {
            result.addAll(spoonFolder.getAllFiles());
        }
        for (SpoonFile spoonFile : this.getFiles()) {
            if (result.contains(spoonFile)) continue;
            result.add(spoonFile);
        }
        return result;
    }

    @Override
    public List<SpoonFile> getAllJavaFiles() {
        ArrayList<SpoonFile> result = new ArrayList<SpoonFile>();
        for (SpoonFile f : this.getAllFiles()) {
            if (!f.isJava()) continue;
            result.add(f);
        }
        return result;
    }

    @Override
    public List<SpoonFile> getFiles() {
        return Collections.unmodifiableList(new ArrayList<SpoonFile>(this.files));
    }

    @Override
    public String getName() {
        return "Virtual directory";
    }

    @Override
    public SpoonFolder getParent() {
        return null;
    }

    @Override
    public List<SpoonFolder> getSubFolders() {
        return Collections.unmodifiableList(new ArrayList<SpoonFolder>(this.folders));
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public String getPath() {
        return ".";
    }

    @Override
    public File getFileSystemParent() {
        return null;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public File toFile() {
        return null;
    }

    public String toString() {
        return "<virtual folder>: " + super.toString();
    }
}

