/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.list.DoubleArrayList;
import cern.jet.math.Arithmetic;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.ExactDoubleQuantileFinder;
import cern.jet.stat.quantile.KnownDoubleQuantileEstimator;
import cern.jet.stat.quantile.UnknownDoubleQuantileEstimator;

public class QuantileFinderFactory {
    protected QuantileFinderFactory() {
    }

    public static long[] known_N_compute_B_and_K(long l, double d, double d2, int n, double[] dArray) {
        dArray[0] = 1.0;
        if (d <= 0.0) {
            long[] lArray = new long[]{1L, l};
            return lArray;
        }
        if (d >= 1.0 || d2 >= 1.0) {
            long[] lArray = new long[]{2L, 1L};
            return lArray;
        }
        if (d2 > 0.0) {
            return QuantileFinderFactory.known_N_compute_B_and_K_slow(l, d, d2, n, dArray);
        }
        return QuantileFinderFactory.known_N_compute_B_and_K_quick(l, d);
    }

    protected static long[] known_N_compute_B_and_K_quick(long l, double d) {
        long l2;
        long l3;
        int n;
        int n2;
        double d2 = l;
        double d3 = d2 * d * 2.0;
        int[] nArray = new int[49];
        for (int i = 2; i <= 50; ++i) {
            for (n2 = 3; n2 <= 50 && (double)(n2 - 2) * Arithmetic.binomial(i + n2 - 2, (long)(n2 - 1)) - Arithmetic.binomial(i + n2 - 3, (long)(n2 - 3)) + Arithmetic.binomial(i + n2 - 3, (long)(n2 - 2)) - d3 > 0.0; ++n2) {
            }
            while (n2 <= 50 && (double)(n2 - 2) * Arithmetic.binomial(i + n2 - 2, (long)(n2 - 1)) - Arithmetic.binomial(i + n2 - 3, (long)(n2 - 3)) + Arithmetic.binomial(i + n2 - 3, (long)(n2 - 2)) - d3 <= 0.0) {
                ++n2;
            }
            n = --n2 >= 50 && (double)(n2 - 2) * Arithmetic.binomial(i + n2 - 2, (long)(n2 - 1)) - Arithmetic.binomial(i + n2 - 3, (long)(n2 - 3)) + Arithmetic.binomial(i + n2 - 3, (long)(n2 - 2)) - d3 > 0.0 ? Integer.MIN_VALUE : n2;
            nArray[i - 2] = n;
        }
        long[] lArray = new long[49];
        for (n2 = 2; n2 <= 50; ++n2) {
            double d4;
            long l4;
            n = nArray[n2 - 2];
            long l5 = Long.MAX_VALUE;
            if (n > Integer.MIN_VALUE && (l4 = (long)Math.ceil(d2 / (d4 = Arithmetic.binomial(n2 + n - 2, (long)(n - 1))))) <= Long.MAX_VALUE) {
                l5 = l4;
            }
            lArray[n2 - 2] = l5;
        }
        long l6 = Long.MAX_VALUE;
        int n3 = -1;
        for (int i = 2; i <= 50; ++i) {
            long l7;
            if (lArray[i - 2] >= Long.MAX_VALUE || (l7 = (long)i * lArray[i - 2]) >= l6) continue;
            l6 = l7;
            n3 = i;
        }
        if (n3 != -1) {
            l3 = n3;
            l2 = lArray[n3 - 2];
        } else {
            l3 = 1L;
            l2 = l;
        }
        long[] lArray2 = new long[]{l3, l2};
        return lArray2;
    }

    protected static long[] known_N_compute_B_and_K_slow(long l, double d, double d2, int n, double[] dArray) {
        double d3 = l;
        long l2 = 1L;
        long l3 = l;
        double d4 = 1.0;
        long l4 = l;
        double d5 = Math.log(2.0 * (double)n / d2);
        double d6 = 2.0 * d * d3;
        for (long i = 2L; i < 50L; ++i) {
            for (long j = 3L; j < 50L; ++j) {
                double d7 = Arithmetic.binomial(i + j - 2L, j - 1L);
                long l5 = (long)Math.ceil(d3 / d7);
                if (i * l5 < l4 && (double)(j - 2L) * d7 - Arithmetic.binomial(i + j - 3L, j - 3L) + Arithmetic.binomial(i + j - 3L, j - 2L) <= d6) {
                    l3 = l5;
                    l2 = i;
                    l4 = l3 * i;
                    d4 = 1.0;
                }
                if (!(d2 > 0.0)) continue;
                double d8 = (double)(j - 2L) * Arithmetic.binomial(i + j - 2L, j - 1L) - Arithmetic.binomial(i + j - 3L, j - 3L) + Arithmetic.binomial(i + j - 3L, j - 2L);
                double d9 = d5 / d;
                double d10 = Arithmetic.binomial(i + j - 2L, j - 1L);
                double d11 = d5 / (2.0 * d * d);
                double d12 = 0.5 + 0.5 * Math.sqrt(1.0 + 4.0 * d8 / d9);
                long l6 = (long)Math.ceil(d11 * d12 * d12 / d10);
                if (i * l6 >= l4) continue;
                l3 = l6;
                l2 = i;
                l4 = i * l6;
                d4 = d3 * 2.0 * d * d / d5;
            }
        }
        long[] lArray = new long[]{l2, l3};
        dArray[0] = d4;
        return lArray;
    }

    public static DoubleQuantileFinder newDoubleQuantileFinder(boolean bl, long l, double d, double d2, int n, RandomEngine randomEngine) {
        if (d <= 0.0 || l < 1000L) {
            return new ExactDoubleQuantileFinder();
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        if (n < 1) {
            n = 1;
        }
        if ((long)n > l) {
            l = n;
        }
        if (bl) {
            double[] dArray = new double[1];
            long[] lArray = QuantileFinderFactory.known_N_compute_B_and_K(l, d, d2, n, dArray);
            long l2 = lArray[0];
            long l3 = lArray[1];
            if (l2 == 1L) {
                return new ExactDoubleQuantileFinder();
            }
            return new KnownDoubleQuantileEstimator((int)l2, (int)l3, l, dArray[0], randomEngine);
        }
        long[] lArray = QuantileFinderFactory.unknown_N_compute_B_and_K(d, d2, n);
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        double d3 = -1.0;
        if (lArray[3] == 1L) {
            d3 = d;
        }
        if (l4 == 1L) {
            return new ExactDoubleQuantileFinder();
        }
        return new UnknownDoubleQuantileEstimator((int)l4, (int)l5, (int)l6, d3, randomEngine);
    }

    public static DoubleArrayList newEquiDepthPhis(int n) {
        DoubleArrayList doubleArrayList = new DoubleArrayList(n - 1);
        for (int i = 1; i <= n - 1; ++i) {
            doubleArrayList.add((double)i / (double)n);
        }
        return doubleArrayList;
    }

    public static long[] unknown_N_compute_B_and_K(double d, double d2, int n) {
        return QuantileFinderFactory.unknown_N_compute_B_and_K_raw(d, d2, n);
    }

    protected static long[] unknown_N_compute_B_and_K_raw(double d, double d2, int n) {
        if (d <= 0.0) {
            long[] lArray = new long[]{1L, Long.MAX_VALUE, Long.MAX_VALUE, 0L};
            return lArray;
        }
        if (d >= 1.0 || d2 >= 1.0) {
            long[] lArray = new long[]{2L, 1L, 3L, 0L};
            return lArray;
        }
        if (d2 <= 0.0) {
            long[] lArray = new long[]{1L, Long.MAX_VALUE, Long.MAX_VALUE, 0L};
            return lArray;
        }
        int n2 = 50;
        int n3 = 50;
        int n4 = 50;
        int n5 = 2;
        long l = Long.MAX_VALUE;
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MAX_VALUE;
        long l4 = Long.MAX_VALUE;
        double d3 = Math.pow(2.0, n4);
        double d4 = Math.log(2.0 / (d2 / (double)n)) / (2.0 * d * d);
        while (l == Long.MAX_VALUE && n5-- > 0) {
            for (int i = 2; i <= n2; ++i) {
                for (int j = 2; j <= n3; ++j) {
                    long l5;
                    double d5;
                    double d6;
                    double d7;
                    double d8;
                    double d9 = Arithmetic.binomial(i + j - 2, (long)(j - 1));
                    double d10 = d4 / Math.min(d9, 8.0 * (d8 = Arithmetic.binomial(i + j - 3, (long)(j - 1))) / 3.0);
                    double d11 = d10 * d10 + 4.0 * d10 * (d7 = ((double)(j + 3) + (d6 = ((d5 = d9 / d8) - 2.0) * ((double)n4 - 2.0) / (d5 + d3 - 2.0))) / (2.0 * d));
                    if (d11 < 0.0) continue;
                    double d12 = Math.sqrt(d11);
                    double d13 = (d10 + 2.0 * d7 + d12) / (2.0 * d7);
                    double d14 = (d10 + 2.0 * d7 - d12) / (2.0 * d7);
                    boolean bl = false;
                    boolean bl2 = false;
                    if (0.0 < d13 && d13 < 1.0) {
                        bl = true;
                    }
                    if (0.0 < d14 && d14 < 1.0) {
                        bl2 = true;
                    }
                    if (!bl && !bl2) continue;
                    double d15 = d13;
                    if (bl && bl2) {
                        d15 = Math.max(d13, d14);
                    } else if (bl2) {
                        d15 = d14;
                    }
                    long l6 = (long)Math.ceil(Math.max(d7 / d15, (double)(j + 1) / (2.0 * d)));
                    if (l6 <= 0L || (l5 = (long)i * l6) >= l4) continue;
                    l2 = l6;
                    l = i;
                    l3 = j;
                    l4 = l5;
                }
            }
            if (l != Long.MAX_VALUE) continue;
            System.out.println("Warning: Computing b and k looks like a lot of work!");
            n2 *= 2;
            n3 *= 2;
            n4 *= 2;
        }
        long[] lArray = new long[4];
        lArray[3] = 0L;
        if (l == Long.MAX_VALUE) {
            lArray[0] = 1L;
            lArray[1] = Long.MAX_VALUE;
            lArray[2] = Long.MAX_VALUE;
        } else {
            lArray[0] = l;
            lArray[1] = l2;
            lArray[2] = l3;
        }
        return lArray;
    }
}

