/*
 * Decompiled with CFR 0.152.
 */
package confusionmtx;

import ev.ex.TreeGenerators;
import fig.exec.Execution;
import goblin.Taxon;
import java.io.File;
import java.util.HashSet;
import java.util.Random;
import nuts.io.IO;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import pty.RootedTree;
import pty.UnrootedTree;

public class LoadTreeTest
implements Runnable {
    public static void main(String[] args) {
        IO.run(args, new LoadTreeTest());
    }

    @Override
    public void run() {
        File f = new File("consensus-greenhill.newick");
        UnrootedTree ut = UnrootedTree.fromNewick(f);
        RootedTree.RootingInfo ri = new RootedTree.RootingInfo(new Taxon("root"), new Taxon("internal342"), new Taxon("newRoot"), 0.5);
        RootedTree rt = ut.reRoot(ri);
        HashSet<Taxon> namedNodes = new HashSet<Taxon>();
        for (Taxon taxon : rt.topology().nodeContents()) {
            if (("" + taxon).matches("(internal.*|.*root.*)")) continue;
            namedNodes.add(taxon);
        }
        System.out.println(namedNodes);
        f = new File("data/austro/bestEditDTrees/pan_list.txt");
        HashSet<Taxon> knownNodes = new HashSet<Taxon>();
        for (String line : IO.i(f)) {
            String[] fields = line.split("\\s+");
            knownNodes.add(new Taxon(fields[0]));
        }
        System.out.println("nNodes(tree)=" + namedNodes.size());
        System.out.println("nNodes(list)=" + knownNodes.size());
        System.out.println("interSize=" + CollUtils.inter(namedNodes, knownNodes).size());
        System.out.println("symmDiff=" + CollUtils.symmetricDifference(namedNodes, knownNodes));
        Arbre<Taxon> arbre = rt.topology();
        Arbre.findFirstNodeWithContents(arbre, new Taxon("PAN")).setContents(new Taxon("ProtoAustronesian"));
        Arbre.findFirstNodeWithContents(arbre, new Taxon("PMP")).setContents(new Taxon("ProtoMalayoPolynesian"));
        Arbre.findFirstNodeWithContents(arbre, new Taxon("protooceanic")).setContents(new Taxon("ProtoOceanicBlust"));
        Arbre<Taxon> arbre2 = Arbre.findFirstNodeWithContents(arbre, new Taxon("ProtoAustronesian"));
        String s = arbre2.deepToLispString();
        IO.writeToDisk(new File(Execution.getFile("consensus-greenhill-topo.topo")), s);
        Arbre<Taxon> flat = new Arbre<Taxon>(new Taxon("ProtoAustronesian"));
        for (Taxon leaf : arbre2.leaveContents()) {
            flat.addLeaves(new Arbre<Taxon>(leaf));
        }
        IO.writeToDisk(new File(Execution.getFile("flat-greenhill-topo.topo")), flat.deepToLispString());
        Random rand = new Random(1L);
        RootedTree randomTree = TreeGenerators.sampleCoalescent(rand, arbre2.leaveContents(), true);
        randomTree.topology().setContents(new Taxon("ProtoAustronesian"));
        IO.writeToDisk(new File(Execution.getFile("random-greenhill-topo.topo")), randomTree.topology().deepToLispString());
    }
}

