/*
 * Decompiled with CFR 0.152.
 */
package conifer.msa;

import conifer.msa.InformedProposal;
import ev.hmm.HetPairHMM;
import ev.par.ExponentialFamily;
import fig.basic.LogInfo;
import fig.basic.Pair;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ma.GreedyDecoder;
import ma.MSAPoset;
import nuts.util.CollUtils;
import nuts.util.Counter;

public class InformedProposals {
    private static InformedProposals singleton = null;
    private static Map<Taxon, String> correspSeqs = null;
    private static Double correspThresh = null;
    Map<Pair<Taxon, Taxon>, InformedProposal> proposals = new HashMap<Pair<Taxon, Taxon>, InformedProposal>();
    private final double threshold;

    public static InformedProposals getSingleton(double threshold, Map<Taxon, String> sequences, ExponentialFamily expFam) {
        if (singleton == null) {
            singleton = new InformedProposals(threshold);
            correspThresh = threshold;
            correspSeqs = sequences;
            singleton.prepare(sequences, expFam);
        }
        if (!sequences.equals(correspSeqs) || threshold != correspThresh) {
            throw new RuntimeException();
        }
        return singleton;
    }

    public MSAPoset getMaxRecallAlignment(Map<Taxon, String> seqns) {
        Counter<GreedyDecoder.Edge> counter = new Counter<GreedyDecoder.Edge>();
        for (Pair<Taxon, Taxon> taxaPair : this.proposals.keySet()) {
            InformedProposal prop = this.proposals.get(taxaPair);
            for (Integer p1 : prop.probabilities.keySet()) {
                if (p1 < 0) continue;
                Counter<Integer> current = prop.probabilities.getCounter(p1);
                for (Integer p2 : current.keySet()) {
                    if (p2 < 0) continue;
                    counter.setCount(new GreedyDecoder.Edge(p1, p2, taxaPair.getFirst(), taxaPair.getSecond()), current.getCount(p2));
                }
            }
        }
        return MSAPoset.maxRecallMSA(seqns, counter);
    }

    public InformedProposals(double threshold) {
        this.threshold = threshold;
    }

    public void prepare(Map<Taxon, String> sequences, ExponentialFamily expFam) {
        LogInfo.track("Preparing informed proposals");
        ArrayList<Taxon> langs = CollUtils.list(sequences.keySet());
        for (int i = 0; i < langs.size(); ++i) {
            LogInfo.logs("" + (1 + i) + "/" + langs.size());
            Taxon l1 = (Taxon)langs.get(i);
            for (int j = i + 1; j < langs.size(); ++j) {
                Taxon l2 = (Taxon)langs.get(j);
                String s1 = sequences.get(l1);
                String s2 = sequences.get(l2);
                HetPairHMM hmm = expFam.getHMM(s1, s2, l1, l2);
                InformedProposal ip1 = InformedProposal.create(l1, l2, s1, s2, hmm, false, this.threshold);
                InformedProposal ip2 = InformedProposal.create(l2, l1, s2, s1, hmm, true, this.threshold);
                this.proposals.put(Pair.makePair(l1, l2), ip1);
                this.proposals.put(Pair.makePair(l2, l1), ip2);
            }
        }
        LogInfo.end_track();
    }
}

