/*
 * Decompiled with CFR 0.152.
 */
package conifer.ssm;

import JSci.maths.statistics.ExponentialDistribution;
import conifer.ssm.Edit;
import conifer.ssm.ForwardSimulator;
import conifer.ssm.StringMutationModel;
import fig.basic.NumUtils;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.math.ProposalRandom;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;
import pepper.editmodel.BayesRiskMinimizer;

public class DiscreteProposals {
    public static List<Edit> proposedEdits(StringMutationModel stringModel, String current, String target, ProposalRandom rand, double boost, double stopPr) {
        ArrayList<Edit> result = new ArrayList<Edit>();
        Edit currentEdit = null;
        while ((currentEdit = DiscreteProposals.proposeEdit(stringModel, current, target, rand, boost, stopPr)) != null) {
            result.add(currentEdit);
            current = currentEdit.newSeq;
        }
        return result;
    }

    public static Edit proposeEdit(StringMutationModel stringModel, String current, String target, ProposalRandom rand, double boost, double stopPr) {
        boolean stop;
        if (current.equals(target) && (stop = rand.sampleBern(stopPr))) {
            return null;
        }
        List<Edit> candidates = stringModel.rates(current).getFirst();
        double[] prs = new double[candidates.size()];
        double currentEditD = BayesRiskMinimizer.computeDist(current, target);
        int nGoodSSMs = 0;
        for (Edit e : candidates) {
            String proposed = e.newSeq;
            double updatedEditD = BayesRiskMinimizer.computeDist(proposed, target);
            if (!e.isRepeat() || !(updatedEditD < currentEditD)) continue;
            ++nGoodSSMs;
        }
        for (int i = 0; i < prs.length; ++i) {
            String proposed = candidates.get((int)i).newSeq;
            double updatedEditD = BayesRiskMinimizer.computeDist(proposed, target);
            prs[i] = 1.0;
            if (!(updatedEditD < currentEditD)) continue;
            boolean breakThings = false;
            if (!candidates.get(i).isRepeat()) {
                List<Edit> subCandidates = stringModel.rates(proposed).getFirst();
                int subGoodSSMs = 0;
                for (Edit e : subCandidates) {
                    String subProposed = candidates.get((int)i).newSeq;
                    double subUpdatedEditD = BayesRiskMinimizer.computeDist(subProposed, target);
                    if (!e.isRepeat() || !(subUpdatedEditD < updatedEditD)) continue;
                    ++subGoodSSMs;
                }
                if (subGoodSSMs < nGoodSSMs) {
                    breakThings = true;
                }
            }
            if (breakThings) continue;
            int n = i;
            prs[n] = prs[n] + boost;
        }
        NumUtils.normalize(prs);
        int index = rand.sampleMultinomial(prs);
        return candidates.get(index);
    }

    public static void main(String[] args) {
        double lambda = 3.0;
        ExponentialDistribution ed = new ExponentialDistribution(lambda);
        System.out.println(1.0 - ed.cumulative(1.0));
        double[][] rate = new double[][]{{-lambda, lambda}, {0.0, 0.0}};
        System.out.println(MatrixFunctions.expm((DoubleMatrix)new DoubleMatrix((double[][])rate)).get(0, 0));
        Random rand = new Random(1L);
        ProposalRandom pRand = new ProposalRandom(rand);
        StringMutationModel model = new StringMutationModel();
        for (int j = 0; j < 100; ++j) {
            String first;
            String current = first = ForwardSimulator.approxStationarySampling(model, rand, 100000);
            String finalStr = null;
            System.out.println("Fwd generated sequence:");
            for (int i = 0; i < 5; ++i) {
                Pair<Edit, Double> sampled = ForwardSimulator.next(current, model, rand);
                finalStr = sampled.getFirst().newSeq;
                System.out.println(sampled.getFirst().newSeq + "\t" + sampled);
                current = sampled.getFirst().newSeq;
            }
            for (int k = 0; k < 10; ++k) {
                System.out.println("Proposed sequence " + k);
                List<Edit> proposedEdits = DiscreteProposals.proposedEdits(model, first, finalStr, pRand, 1000.0, 0.95);
                for (Edit e : proposedEdits) {
                    System.out.println(e);
                }
            }
            System.out.println("\n\n\n==========\n\n\n");
        }
    }
}

