/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

public class BFloat
implements Cloneable {
    float iF;
    int iE;
    private static final float iRange = 2.028241E31f;
    private static final float iRangeInv = 4.9303807E-32f;
    private static final float iLogRange = (float)Math.log(2.028240960365167E31);
    private static final float iHalfRange = 1.0E18f;
    private static final float iHalfRangeInv = 1.0E-18f;
    private static final int iInfExp = 1000000000;
    private static final boolean iCheckOF = false;
    private static final int iConvTableSize = 100;
    private static float[] iConvTable = new float[100];

    public Object clone() {
        try {
            BFloat iObj = (BFloat)super.clone();
            iObj.iE = this.iE;
            iObj.iF = this.iF;
            return iObj;
        }
        catch (CloneNotSupportedException e) {
            System.out.println("BFloat.clone: Something happened that cannot happen -- ?");
            return null;
        }
    }

    public String toString() {
        String iResult;
        if (this.iE == 1000000000) {
            iResult = "1.0e+Inf";
        } else if (this.iE == -1000000000) {
            iResult = "1.0e-Inf";
        } else {
            float iFM;
            double iM = (Math.log(this.iF) + Math.log(2.028240960365167E31) * (double)this.iE) / Math.log(10.0);
            long iExp = (long)Math.floor(iM);
            if ((iFM = (float)Math.exp((iM -= Math.floor(iM)) * Math.log(10.0))) >= 10.0f) {
                iFM = 1.0f;
                ++iExp;
            }
            iResult = String.valueOf(iFM) + "e";
            iResult = iExp < 0L ? iResult + String.valueOf(iExp) : iResult + "+" + String.valueOf(iExp);
        }
        return iResult;
    }

    private void normalise() {
        if ((double)this.iF > 0.0) {
            while (this.iF > 1.0E18f) {
                this.iF *= 4.9303807E-32f;
                ++this.iE;
            }
            while (this.iF < 1.0E-18f) {
                this.iF *= 2.028241E31f;
                --this.iE;
            }
        } else if ((double)this.iF < 0.0) {
            while (this.iF < -1.0E18f) {
                this.iF *= 4.9303807E-32f;
                ++this.iE;
            }
            while (this.iF > -1.0E-18f) {
                this.iF *= 2.028241E31f;
                --this.iE;
            }
        } else {
            this.iE = -1000000000;
        }
    }

    private void normaliseOnce() {
        if ((double)this.iF > 0.0) {
            if (this.iF > 1.0E18f) {
                this.iF *= 4.9303807E-32f;
                ++this.iE;
            } else if (this.iF < 1.0E-18f) {
                this.iF *= 2.028241E31f;
                --this.iE;
            }
        } else if ((double)this.iF < 0.0) {
            if (this.iF < -1.0E18f) {
                this.iF *= 4.9303807E-32f;
                ++this.iE;
            } else if (this.iF > -1.0E-18f) {
                this.iF *= 2.028241E31f;
                --this.iE;
            }
        } else {
            this.iE = -1000000000;
        }
    }

    public BFloat(float iX) {
        this.iF = iX;
        this.iE = 0;
        this.normalise();
    }

    public BFloat(double iX) {
        int iExp = 0;
        if (iX > 0.0) {
            while (iX > (double)1.0E18f) {
                iX *= 4.930380657631324E-32;
                ++iExp;
            }
            while (iX < (double)1.0E-18f) {
                iX *= 2.028240960365167E31;
                --iExp;
            }
        } else if (iX < 0.0) {
            while (iX < (double)-1.0E18f) {
                iX *= 4.930380657631324E-32;
                ++iExp;
            }
            while (iX > (double)-1.0E-18f) {
                iX *= 2.028240960365167E31;
                --iExp;
            }
        } else {
            iExp = -1000000000;
        }
        this.iF = (float)iX;
        this.iE = iExp;
    }

    public BFloat(float iF, int iE) {
        this.iF = iF;
        this.iE = iE;
    }

    public static BFloat exp(float iX) {
        int iN = Math.round(iX / iLogRange);
        return new BFloat((float)Math.exp(iX - (float)iN * iLogRange), iN);
    }

    public double log() {
        return (double)this.iE * (double)iLogRange + Math.log(this.iF);
    }

    public void add(BFloat iBF) {
        if (this.iE >= iBF.iE) {
            if (this.iE < iBF.iE + 100) {
                this.iF += iBF.iF * iConvTable[this.iE - iBF.iE];
            }
        } else if (this.iE > iBF.iE - 100) {
            this.iF = iBF.iF + this.iF * iConvTable[iBF.iE - this.iE];
            this.iE = iBF.iE;
        } else {
            this.iF = iBF.iF;
            this.iE = iBF.iE;
        }
    }

    public void add(float iX) {
        this.add(new BFloat(iX));
    }

    public void add(double iX) {
        this.add(new BFloat(iX));
    }

    public void multiply(BFloat iBF) {
        this.iF *= iBF.iF;
        this.iE += iBF.iE;
        this.normaliseOnce();
    }

    public void multiply(float iX) {
        this.multiply(new BFloat(iX));
    }

    public void multiply(double iX) {
        this.multiply(new BFloat(iX));
    }

    static {
        BFloat.iConvTable[0] = 1.0f;
        for (int i = 1; i < 100; ++i) {
            BFloat.iConvTable[i] = iConvTable[i - 1] * 4.9303807E-32f;
        }
    }
}

