/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.ComplexArray;

public class FastFourierTransform {
    public static void fft(double[] data, int nn, boolean inverse) {
        int m;
        int i;
        double radians = inverse ? Math.PI * 2 : Math.PI * -2;
        int n = nn << 1;
        int j = 1;
        for (i = 1; i < n; i += 2) {
            if (j > i) {
                FastFourierTransform.swap(data, j - 1, i - 1);
                FastFourierTransform.swap(data, j, i);
            }
            for (m = nn; m >= 2 && j > m; j -= m, m >>= 1) {
            }
            j += m;
        }
        int mmax = 2;
        while (n > mmax) {
            int istep = mmax << 1;
            double theta = radians / (double)mmax;
            double wtemp = Math.sin(0.5 * theta);
            double wpr = -2.0 * wtemp * wtemp;
            double wpi = Math.sin(theta);
            double wr = 1.0;
            double wi = 0.0;
            for (m = 1; m < mmax; m += 2) {
                for (i = m; i <= n; i += istep) {
                    j = i + mmax;
                    double tempr = wr * data[j - 1] - wi * data[j];
                    double tempi = wr * data[j] + wi * data[j - 1];
                    data[j - 1] = data[i - 1] - tempr;
                    data[j] = data[i] - tempi;
                    int n2 = i - 1;
                    data[n2] = data[n2] + tempr;
                    int n3 = i;
                    data[n3] = data[n3] + tempi;
                }
                wtemp = wr;
                wr += wr * wpr - wi * wpi;
                wi += wi * wpr + wtemp * wpi;
            }
            mmax = istep;
        }
    }

    public static void fft(ComplexArray ca, boolean inverse) {
        int m;
        int halfJ;
        int halfI;
        int i;
        double[] real = ca.real;
        double[] complex = ca.complex;
        double radians = inverse ? Math.PI * 2 : Math.PI * -2;
        int n = ca.length << 1;
        int j = 1;
        for (i = 1; i < n; i += 2) {
            if (j > i) {
                halfI = i >> 1;
                halfJ = j >> 1;
                FastFourierTransform.swap(real, halfJ, halfI);
                FastFourierTransform.swap(complex, halfJ, halfI);
            }
            for (m = ca.length; m >= 2 && j > m; j -= m, m >>= 1) {
            }
            j += m;
        }
        int mmax = 2;
        while (n > mmax) {
            int istep = mmax << 1;
            double theta = radians / (double)mmax;
            double wtemp = Math.sin(0.5 * theta);
            double wpr = -2.0 * wtemp * wtemp;
            double wpi = Math.sin(theta);
            double wr = 1.0;
            double wi = 0.0;
            for (m = 1; m < mmax; m += 2) {
                for (i = m; i <= n; i += istep) {
                    j = i + mmax;
                    halfI = i >> 1;
                    halfJ = j >> 1;
                    double tempr = wr * real[halfJ] - wi * complex[halfJ];
                    double tempi = wr * complex[halfJ] + wi * real[halfJ];
                    real[halfJ] = real[halfI] - tempr;
                    complex[halfJ] = complex[halfI] - tempi;
                    int n2 = halfI;
                    real[n2] = real[n2] + tempr;
                    int n3 = halfI;
                    complex[n3] = complex[n3] + tempi;
                }
                wtemp = wr;
                wr += wr * wpr - wi * wpi;
                wi += wi * wpr + wtemp * wpi;
            }
            mmax = istep;
        }
    }

    private static void swap(double[] x, int i, int j) {
        double tmp = x[i];
        x[i] = x[j];
        x[j] = tmp;
    }
}

