/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.BigDecimalUtils;
import dr.math.LogTricks;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;

public interface Polynomial
extends Cloneable {
    public int getDegree();

    public Polynomial multiply(Polynomial var1);

    public Polynomial integrate();

    public double evaluate(double var1);

    public double logEvaluate(double var1);

    public double logEvaluateHorner(double var1);

    public void expand(double var1);

    public Polynomial integrateWithLowerBound(double var1);

    public double getCoefficient(int var1);

    public String getCoefficientString(int var1);

    public void setCoefficient(int var1, double var2);

    public Polynomial getPolynomial();

    public Polynomial copy();

    public static enum Type {
        DOUBLE,
        APDOUBLE,
        LOG_DOUBLE,
        BIG_DOUBLE;

    }

    public static class Double
    extends Abstract {
        double[] coefficient;

        public Double(double[] coefficient) {
            this.coefficient = coefficient;
        }

        @Override
        public Double copy() {
            return new Double((double[])this.coefficient.clone());
        }

        public Double(Polynomial polynomial) {
            this.coefficient = new double[polynomial.getDegree() + 1];
            for (int n = 0; n <= polynomial.getDegree(); ++n) {
                this.coefficient[n] = polynomial.getCoefficient(n);
            }
        }

        @Override
        public void expand(double x) {
            int degree = this.getDegree();
            for (int i = 0; i <= degree; ++i) {
                this.coefficient[i] = x * this.coefficient[i];
            }
        }

        @Override
        public String getCoefficientString(int n) {
            return String.format("%3.2e", this.getCoefficient(n));
        }

        @Override
        public int getDegree() {
            return this.coefficient.length - 1;
        }

        @Override
        public double getCoefficient(int n) {
            return this.coefficient[n];
        }

        @Override
        public double logEvaluate(double x) {
            return Math.log(this.evaluate(x));
        }

        public double logEvaluateQuick(double x, int n) {
            return Math.log(this.evaluateQuick(x, n));
        }

        @Override
        public double logEvaluateHorner(double x) {
            int degree = this.getDegree();
            double logX = Math.log(x);
            boolean positive = this.coefficient[degree] > 0.0;
            double logResult = positive ? Math.log(this.coefficient[degree]) : Math.log(-this.coefficient[degree]);
            for (int n = degree - 1; n >= 0; --n) {
                logResult += logX;
                boolean positiveCoefficient = this.coefficient[n] > 0.0;
                double logCoefficient = positiveCoefficient ? Math.log(this.coefficient[n]) : Math.log(-this.coefficient[n]);
                if (!(positiveCoefficient ^ positive)) {
                    logResult = LogTricks.logSum(logResult, logCoefficient);
                    continue;
                }
                if (logResult > logCoefficient) {
                    logResult = LogTricks.logDiff(logResult, logCoefficient);
                    continue;
                }
                logResult = LogTricks.logDiff(logCoefficient, logResult);
                positive = !positive;
            }
            if (!positive) {
                return java.lang.Double.NaN;
            }
            return logResult;
        }

        @Override
        public Double multiply(Polynomial b) {
            double[] newCoefficient = new double[this.getDegree() + b.getDegree() + 1];
            for (int n = 0; n <= this.getDegree(); ++n) {
                for (int m = 0; m <= b.getDegree(); ++m) {
                    int n2 = n + m;
                    newCoefficient[n2] = newCoefficient[n2] + this.coefficient[n] * b.getCoefficient(m);
                }
            }
            return new Double(newCoefficient);
        }

        @Override
        public Double integrate() {
            double[] newCoefficient = new double[this.getDegree() + 2];
            for (int n = 0; n <= this.getDegree(); ++n) {
                newCoefficient[n + 1] = this.coefficient[n] / (double)(n + 1);
            }
            return new Double(newCoefficient);
        }

        public double evaluateHorners(double x) {
            int degree = this.getDegree();
            double result = this.coefficient[degree];
            for (int n = degree - 1; n >= 0; --n) {
                result = result * x + this.coefficient[n];
            }
            return result;
        }

        public double evaluateQuick(double x, int n) {
            int m = this.getDegree();
            double xm = Math.pow(x, m);
            double result = xm * this.coefficient[m];
            for (int i = n - 1; i > 0; --i) {
                result += (xm /= x) * this.coefficient[--m];
            }
            return result;
        }

        @Override
        public double evaluate(double x) {
            double result = 0.0;
            double xn = 1.0;
            for (int n = 0; n <= this.getDegree(); ++n) {
                result += xn * this.coefficient[n];
                xn *= x;
            }
            return result;
        }

        @Override
        public Polynomial integrateWithLowerBound(double bound) {
            Double integrand = this.integrate();
            integrand.coefficient[0] = -integrand.evaluate(bound);
            return integrand;
        }

        @Override
        public void setCoefficient(int n, double x) {
            this.coefficient[n] = x;
        }
    }

    public static class BigDouble
    extends Abstract {
        private static MathContext precision = new MathContext(1000);
        BigDecimal[] coefficient;

        public BigDouble(double[] doubleCoefficient) {
            this.coefficient = new BigDecimal[doubleCoefficient.length];
            for (int i = 0; i < doubleCoefficient.length; ++i) {
                this.coefficient[i] = new BigDecimal(doubleCoefficient[i]);
            }
        }

        @Override
        public BigDouble copy() {
            return new BigDouble((BigDecimal[])this.coefficient.clone());
        }

        @Override
        public String getCoefficientString(int n) {
            return this.coefficient[n].toString();
        }

        @Override
        public void expand(double x) {
            throw new RuntimeException("Not yet implement: Polynomial.BigDouble.expand()");
        }

        public BigDouble(BigDecimal[] coefficient) {
            this.coefficient = coefficient;
        }

        @Override
        public int getDegree() {
            return this.coefficient.length - 1;
        }

        @Override
        public BigDouble multiply(Polynomial b) {
            if (!(b.getPolynomial() instanceof BigDouble)) {
                throw new RuntimeException("Incompatiable polynomial types");
            }
            BigDouble bd = (BigDouble)b.getPolynomial();
            BigDecimal[] newCoefficient = new BigDecimal[this.getDegree() + bd.getDegree() + 1];
            for (int i = 0; i < newCoefficient.length; ++i) {
                newCoefficient[i] = new BigDecimal(0.0);
            }
            for (int n = 0; n <= this.getDegree(); ++n) {
                for (int m = 0; m <= bd.getDegree(); ++m) {
                    newCoefficient[n + m] = newCoefficient[n + m].add(this.coefficient[n].multiply(bd.coefficient[m]));
                }
            }
            return new BigDouble(newCoefficient);
        }

        @Override
        public BigDouble integrate() {
            BigDecimal[] newCoefficient = new BigDecimal[this.getDegree() + 2];
            for (int n = 0; n <= this.getDegree(); ++n) {
                newCoefficient[n + 1] = this.coefficient[n].divide(new BigDecimal(n + 1), precision);
            }
            newCoefficient[0] = new BigDecimal(0.0);
            return new BigDouble(newCoefficient);
        }

        @Override
        public double evaluate(double x) {
            return this.evaluateBigDecimal(new BigDecimal(x)).doubleValue();
        }

        @Override
        public double logEvaluate(double x) {
            return BigDecimalUtils.ln(this.evaluateBigDecimal(new BigDecimal(x)), 10).doubleValue();
        }

        @Override
        public double logEvaluateHorner(double x) {
            return this.logEvaluate(x);
        }

        protected BigDecimal evaluateBigDecimal(BigDecimal x) {
            BigDecimal result = new BigDecimal(0.0);
            BigDecimal xn = new BigDecimal(1.0);
            for (int n = 0; n <= this.getDegree(); ++n) {
                result = result.add(this.coefficient[n].multiply(xn));
                xn = xn.multiply(x);
            }
            return result;
        }

        @Override
        public double getCoefficient(int n) {
            return this.coefficient[n].doubleValue();
        }

        @Override
        public void setCoefficient(int n, double x) {
            this.coefficient[n] = new BigDecimal(x);
        }

        @Override
        public Polynomial integrateWithLowerBound(double bound) {
            BigDouble integrand = this.integrate();
            BigDecimal x0 = integrand.evaluateBigDecimal(new BigDecimal(bound));
            integrand.coefficient[0] = x0.multiply(new BigDecimal(-1.0));
            return integrand;
        }

        public void setCoefficient(int n, BigDecimal x) {
            this.coefficient[n] = x;
        }
    }

    public static class LogDouble
    extends Abstract {
        double[] logCoefficient;
        boolean[] positiveCoefficient;

        public LogDouble(double[] coefficient) {
            this.logCoefficient = new double[coefficient.length];
            this.positiveCoefficient = new boolean[coefficient.length];
            for (int i = 0; i < coefficient.length; ++i) {
                if (coefficient[i] < 0.0) {
                    this.logCoefficient[i] = Math.log(-coefficient[i]);
                    this.positiveCoefficient[i] = false;
                    continue;
                }
                this.logCoefficient[i] = Math.log(coefficient[i]);
                this.positiveCoefficient[i] = true;
            }
        }

        public double getLogCoefficient(int n) {
            return this.logCoefficient[n];
        }

        @Override
        public void expand(double x) {
            int degree = this.getDegree();
            for (int i = 0; i <= degree; ++i) {
                this.logCoefficient[i] = x + this.logCoefficient[i];
            }
        }

        @Override
        public String getCoefficientString(int n) {
            return String.format("%3.2e", this.getCoefficient(n));
        }

        public LogDouble(double[] logCoefficient, boolean[] positiveCoefficient) {
            this.logCoefficient = logCoefficient;
            if (positiveCoefficient != null) {
                this.positiveCoefficient = positiveCoefficient;
            } else {
                this.positiveCoefficient = new boolean[logCoefficient.length];
                Arrays.fill(this.positiveCoefficient, true);
            }
        }

        @Override
        public LogDouble copy() {
            return new LogDouble((double[])this.logCoefficient.clone(), (boolean[])this.positiveCoefficient.clone());
        }

        @Override
        public int getDegree() {
            return this.logCoefficient.length - 1;
        }

        @Override
        public LogDouble multiply(Polynomial inB) {
            if (!(inB.getPolynomial() instanceof LogDouble)) {
                throw new RuntimeException("yuck!");
            }
            LogDouble b = (LogDouble)inB.getPolynomial();
            int degreeA = this.getDegree();
            int degreeB = b.getDegree();
            double[] newLogCoefficient = new double[degreeA + degreeB + 1];
            boolean[] newPositiveCoefficient = new boolean[degreeA + degreeB + 1];
            Arrays.fill(newLogCoefficient, java.lang.Double.NEGATIVE_INFINITY);
            Arrays.fill(newPositiveCoefficient, true);
            for (int n = 0; n <= degreeA; ++n) {
                for (int m = 0; m <= degreeB; ++m) {
                    boolean positiveChange;
                    double change = this.logCoefficient[n] + b.logCoefficient[m];
                    int nm = n + m;
                    boolean bl = positiveChange = !(this.positiveCoefficient[n] ^ b.positiveCoefficient[m]);
                    if (newLogCoefficient[nm] == java.lang.Double.NEGATIVE_INFINITY) {
                        newLogCoefficient[nm] = change;
                        newPositiveCoefficient[nm] = positiveChange;
                        continue;
                    }
                    if (change == 0.0) continue;
                    if (newPositiveCoefficient[nm] ^ positiveChange) {
                        if (newLogCoefficient[nm] > change) {
                            newLogCoefficient[nm] = LogTricks.logDiff(newLogCoefficient[nm], change);
                            continue;
                        }
                        newLogCoefficient[nm] = LogTricks.logDiff(change, newLogCoefficient[nm]);
                        newPositiveCoefficient[nm] = !newPositiveCoefficient[nm];
                        continue;
                    }
                    newLogCoefficient[nm] = LogTricks.logSum(newLogCoefficient[nm], change);
                }
            }
            return new LogDouble(newLogCoefficient, newPositiveCoefficient);
        }

        @Override
        public LogDouble integrate() {
            int degree = this.getDegree();
            double[] newLogCoefficient = new double[degree + 2];
            boolean[] newPositiveCoefficient = new boolean[degree + 2];
            for (int n = 0; n <= degree; ++n) {
                newLogCoefficient[n + 1] = this.logCoefficient[n] - Math.log(n + 1);
                newPositiveCoefficient[n + 1] = this.positiveCoefficient[n];
            }
            newLogCoefficient[0] = java.lang.Double.NEGATIVE_INFINITY;
            newPositiveCoefficient[0] = true;
            return new LogDouble(newLogCoefficient, newPositiveCoefficient);
        }

        @Override
        public double evaluate(double x) {
            SignedLogDouble result = this.signedLogEvaluate(x);
            double value = Math.exp(result.value);
            if (!result.positive) {
                value = -value;
            }
            return value;
        }

        public double evaluateAsReal(double x) {
            double result = 0.0;
            double xn = 1.0;
            for (int n = 0; n <= this.getDegree(); ++n) {
                result += xn * this.getCoefficient(n);
                xn *= x;
            }
            return result;
        }

        @Override
        public double logEvaluate(double x) {
            if (x < 0.0) {
                throw new RuntimeException("Negative arguments not yet implemented in Polynomial.LogDouble");
            }
            SignedLogDouble result = this.signedLogEvaluate(x);
            if (result.positive) {
                return result.value;
            }
            return java.lang.Double.NaN;
        }

        @Override
        public double logEvaluateHorner(double x) {
            if (x < 0.0) {
                throw new RuntimeException("Negative arguments not yet implemented in Polynomial.LogDouble");
            }
            SignedLogDouble result = this.signedLogEvaluateHorners(x);
            if (result.positive) {
                return result.value;
            }
            return java.lang.Double.NaN;
        }

        public SignedLogDouble signedLogEvaluateHorners(double x) {
            double logX = Math.log(x);
            int degree = this.getDegree();
            double logResult = this.logCoefficient[degree];
            boolean positive = this.positiveCoefficient[degree];
            for (int n = degree - 1; n >= 0; --n) {
                logResult += logX;
                if (!(this.positiveCoefficient[n] ^ positive)) {
                    logResult = LogTricks.logSum(logResult, this.logCoefficient[n]);
                    continue;
                }
                if (logResult > this.logCoefficient[n]) {
                    logResult = LogTricks.logDiff(logResult, this.logCoefficient[n]);
                    continue;
                }
                logResult = LogTricks.logDiff(this.logCoefficient[n], logResult);
                positive = !positive;
            }
            return new SignedLogDouble(logResult, positive);
        }

        private SignedLogDouble signedLogEvaluate(double x) {
            double logX = Math.log(x);
            int degree = this.getDegree();
            double logResult = this.logCoefficient[0];
            boolean positive = this.positiveCoefficient[0];
            for (int n = 1; n <= degree; ++n) {
                double value = (double)n * logX + this.logCoefficient[n];
                if (!(this.positiveCoefficient[n] ^ positive)) {
                    logResult = LogTricks.logSum(logResult, value);
                    continue;
                }
                if (logResult > value) {
                    logResult = LogTricks.logDiff(logResult, value);
                    continue;
                }
                logResult = LogTricks.logDiff(value, logResult);
                positive = !positive;
            }
            return new SignedLogDouble(logResult, positive);
        }

        @Override
        public double getCoefficient(int n) {
            double coef = Math.exp(this.logCoefficient[n]);
            if (!this.positiveCoefficient[n]) {
                coef *= -1.0;
            }
            return coef;
        }

        @Override
        public void setCoefficient(int n, double x) {
            if (x < 0.0) {
                this.positiveCoefficient[n] = false;
                x = -x;
            } else {
                this.positiveCoefficient[n] = true;
            }
            this.logCoefficient[n] = Math.log(x);
        }

        @Override
        public Polynomial integrateWithLowerBound(double bound) {
            LogDouble integrand = this.integrate();
            SignedLogDouble signedLogDouble = integrand.signedLogEvaluate(bound);
            integrand.logCoefficient[0] = signedLogDouble.value;
            integrand.positiveCoefficient[0] = !signedLogDouble.positive;
            return integrand;
        }

        class SignedLogDouble {
            double value;
            boolean positive;

            SignedLogDouble(double value, boolean positive) {
                this.value = value;
                this.positive = positive;
            }
        }
    }

    public static abstract class Abstract
    implements Polynomial {
        protected static final String FORMAT = "%3.2e";
        private static final String X = " x^";

        @Override
        public abstract int getDegree();

        @Override
        public abstract Polynomial multiply(Polynomial var1);

        @Override
        public abstract Polynomial integrate();

        @Override
        public abstract double evaluate(double var1);

        @Override
        public abstract double getCoefficient(int var1);

        @Override
        public abstract void setCoefficient(int var1, double var2);

        @Override
        public abstract Polynomial integrateWithLowerBound(double var1);

        @Override
        public Polynomial getPolynomial() {
            return this;
        }

        @Override
        public abstract double logEvaluate(double var1);

        @Override
        public abstract double logEvaluateHorner(double var1);

        @Override
        public abstract void expand(double var1);

        public String toString() {
            StringBuffer bf = new StringBuffer();
            for (int n = this.getDegree(); n >= 0; --n) {
                bf.append(this.getCoefficientString(n));
                bf.append(X);
                bf.append(n);
                if (n <= 0) continue;
                bf.append(" + ");
            }
            return bf.toString();
        }

        @Override
        public abstract String getCoefficientString(int var1);
    }
}

