/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.distributions.GammaDistribution;

public class ChiSquareDistribution
extends GammaDistribution {
    protected double n;

    public ChiSquareDistribution(double n) {
        super(n / 2.0, 2.0);
        this.n = n;
    }

    @Override
    public double pdf(double x) {
        return ChiSquareDistribution.pdf(x, this.n);
    }

    @Override
    public double cdf(double x) {
        return ChiSquareDistribution.cdf(x, this.n);
    }

    @Override
    public double quantile(double y) {
        return ChiSquareDistribution.quantile(y, this.n);
    }

    @Override
    public double mean() {
        return ChiSquareDistribution.mean(this.n);
    }

    @Override
    public double variance() {
        return ChiSquareDistribution.variance(this.n);
    }

    public static double pdf(double x, double n) {
        return ChiSquareDistribution.pdf(x, n / 2.0, 2.0);
    }

    public static double cdf(double x, double n) {
        return ChiSquareDistribution.cdf(x, n / 2.0, 2.0);
    }

    public static double quantile(double y, double n) {
        return ChiSquareDistribution.quantile(y, n / 2.0, 2.0);
    }

    public static double mean(double n) {
        return n;
    }

    public static double variance(double n) {
        return 2.0 * n;
    }
}

