/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.GammaFunction;
import dr.math.distributions.MultivariateDistribution;

public class DirichletDistribution
implements MultivariateDistribution {
    public static final String TYPE = "dirichletDistribution";
    private double[] counts;
    private double countSum = 0.0;
    private int dim;
    private double logNormalizingConstant;

    public DirichletDistribution(double[] counts) {
        this.counts = counts;
        this.dim = counts.length;
        for (int i = 0; i < this.dim; ++i) {
            this.countSum += counts[i];
        }
        this.computeNormalizingConstant();
    }

    private void computeNormalizingConstant() {
        this.logNormalizingConstant = GammaFunction.lnGamma(this.countSum);
        for (int i = 0; i < this.dim; ++i) {
            this.logNormalizingConstant -= GammaFunction.lnGamma(this.counts[i]);
        }
    }

    @Override
    public double logPdf(double[] x) {
        if (x.length != this.dim) {
            throw new IllegalArgumentException("data array is of the wrong dimension");
        }
        double logPDF = this.logNormalizingConstant;
        for (int i = 0; i < this.dim; ++i) {
            logPDF += (this.counts[i] - 1.0) * Math.log(x[i]);
            if (!(x[i] <= 0.0) && !(x[i] >= 1.0)) continue;
            logPDF = Double.NEGATIVE_INFINITY;
            break;
        }
        return logPDF;
    }

    @Override
    public double[][] getScaleMatrix() {
        return null;
    }

    @Override
    public double[] getMean() {
        double[] mean = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            mean[i] = this.counts[i] / this.countSum;
        }
        return mean;
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

