/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class LaplaceDistribution
implements Distribution {
    double mu;
    double beta;
    double c;
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return LaplaceDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };

    public LaplaceDistribution(double mu, double beta) {
        this.setParameters(mu, beta);
    }

    public LaplaceDistribution() {
        this(0.0, 1.0);
    }

    public void setParameters(double k, double b) {
        if (b <= 0.0) {
            b = 1.0;
        }
        this.mu = k;
        this.beta = b;
        this.c = 1.0 / (2.0 * this.beta);
    }

    public double getMu() {
        return this.mu;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getMaxDensity() {
        return this.c;
    }

    @Override
    public double cdf(double x) {
        if (x == this.mu) {
            return 0.5;
        }
        return 0.5 * (1.0 + (x - this.mu) / Math.abs(x - this.mu) * (1.0 - Math.exp(-Math.abs(x - this.mu) / this.beta)));
    }

    @Override
    public double pdf(double x) {
        return this.c * Math.exp(-Math.abs(x - this.mu) / this.beta);
    }

    @Override
    public double logPdf(double x) {
        return Math.log(this.c) - Math.abs(x - this.mu) / this.beta;
    }

    @Override
    public double quantile(double y) {
        double sign = 1.0;
        if (y < 0.5) {
            sign = -1.0;
        }
        return this.mu - this.beta * sign * Math.log(1.0 - 2.0 * Math.abs(y - 0.5));
    }

    @Override
    public double mean() {
        return this.mu;
    }

    @Override
    public double variance() {
        return 2.0 * this.beta * this.beta;
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }
}

