/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.distributions.GammaDistribution;
import dr.math.distributions.MultivariateDistribution;

public class MultivariateGammaDistribution
implements MultivariateDistribution {
    public static final String TYPE = "multivariateGamma";
    private double[] shape;
    private double[] scale;
    private int dim;

    public MultivariateGammaDistribution(double[] shape, double[] scale) {
        if (shape.length != scale.length) {
            throw new RuntimeException("Creation error in MultivariateGammaDistribution");
        }
        this.dim = shape.length;
        this.shape = shape;
        this.scale = scale;
    }

    @Override
    public double logPdf(double[] x) {
        double logPdf = 0.0;
        if (x.length != this.dim) {
            throw new IllegalArgumentException("data array is of the wrong dimension");
        }
        for (int i = 0; i < this.dim; ++i) {
            logPdf += GammaDistribution.logPdf(x[i], this.shape[i], this.scale[i]);
        }
        return logPdf;
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getMean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

