/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class UniformDistribution
implements Distribution {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return UniformDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return UniformDistribution.this.lower;
        }

        @Override
        public final double getUpperBound() {
            return UniformDistribution.this.upper;
        }
    };
    private final double upper;
    private final double lower;

    public UniformDistribution(double lower, double upper) {
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public double pdf(double x) {
        return UniformDistribution.pdf(x, this.lower, this.upper);
    }

    @Override
    public double logPdf(double x) {
        return UniformDistribution.logPdf(x, this.lower, this.upper);
    }

    @Override
    public double cdf(double x) {
        return UniformDistribution.cdf(x, this.lower, this.upper);
    }

    @Override
    public double quantile(double y) {
        return UniformDistribution.quantile(y, this.lower, this.upper);
    }

    @Override
    public double mean() {
        return UniformDistribution.mean(this.lower, this.upper);
    }

    @Override
    public double variance() {
        return UniformDistribution.variance(this.lower, this.upper);
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double x, double lower, double upper) {
        return x >= lower && x <= upper ? 1.0 / (upper - lower) : 0.0;
    }

    public static double logPdf(double x, double lower, double upper) {
        if (x < lower || x > upper) {
            return Double.NEGATIVE_INFINITY;
        }
        return -Math.log(upper - lower);
    }

    public static double cdf(double x, double lower, double upper) {
        if (x < lower) {
            return 0.0;
        }
        if (x > upper) {
            return 1.0;
        }
        return (x - lower) / (upper - lower);
    }

    public static double quantile(double y, double lower, double upper) {
        if (!(y >= 0.0) || !(y <= 1.0)) {
            throw new IllegalArgumentException("y must in range [0,1]");
        }
        return y * (upper - lower) + lower;
    }

    public static double mean(double lower, double upper) {
        return (upper + lower) / 2.0;
    }

    public static double variance(double lower, double upper) {
        return (upper - lower) * (upper - lower) / 12.0;
    }
}

