/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.iterations.IterativeProcess;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.Vector;

public class LargestEigenvalueFinder
extends IterativeProcess {
    private double eigenvalue;
    private Vector eigenvector;
    private Vector transposedEigenvector;
    private Matrix matrix;

    public LargestEigenvalueFinder(double prec, Matrix a) {
        this(a);
        this.setDesiredPrecision(prec);
    }

    public LargestEigenvalueFinder(Matrix a) {
        this.matrix = a;
        this.eigenvalue = Double.NaN;
    }

    public double eigenvalue() {
        return this.eigenvalue;
    }

    public Vector eigenvector() {
        return this.eigenvector.product(1.0 / this.eigenvector.norm());
    }

    @Override
    public double evaluateIteration() {
        double oldEigenvalue = this.eigenvalue;
        this.transposedEigenvector = this.transposedEigenvector.secureProduct(this.matrix);
        this.transposedEigenvector = this.transposedEigenvector.product(1.0 / this.transposedEigenvector.components[0]);
        this.eigenvector = this.matrix.secureProduct(this.eigenvector);
        this.eigenvalue = this.eigenvector.components[0];
        this.eigenvector = this.eigenvector.product(1.0 / this.eigenvalue);
        return Double.isNaN(oldEigenvalue) ? 10.0 * this.getDesiredPrecision() : Math.abs(this.eigenvalue - oldEigenvalue);
    }

    @Override
    public void initializeIterations() {
        int i;
        this.eigenvalue = Double.NaN;
        int n = this.matrix.columns();
        double[] eigenvectorComponents = new double[n];
        for (i = 0; i < n; ++i) {
            eigenvectorComponents[i] = 1.0;
        }
        this.eigenvector = new Vector(eigenvectorComponents);
        n = this.matrix.rows();
        eigenvectorComponents = new double[n];
        for (i = 0; i < n; ++i) {
            eigenvectorComponents[i] = 1.0;
        }
        this.transposedEigenvector = new Vector(eigenvectorComponents);
    }

    public LargestEigenvalueFinder nextLargestEigenvalueFinder() {
        double norm = 1.0 / this.eigenvector.secureProduct(this.transposedEigenvector);
        Vector v1 = this.eigenvector.product(norm);
        return new LargestEigenvalueFinder(this.getDesiredPrecision(), this.matrix.secureProduct(SymmetricMatrix.identityMatrix(v1.dimension()).secureSubtract(v1.tensorProduct(this.transposedEigenvector))));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.eigenvalue);
        sb.append(" (");
        sb.append(this.eigenvector.toString());
        sb.append(')');
        return sb.toString();
    }
}

