/*
 * Decompiled with CFR 0.152.
 */
package dr.stats;

import dr.util.HeapSort;

public class DiscreteStatistics {
    public static double mean(double[] x) {
        double m = 0.0;
        int count = x.length;
        for (double aX : x) {
            if (Double.isNaN(aX)) {
                --count;
                continue;
            }
            m += aX;
        }
        return m / (double)count;
    }

    public static double median(double[] x, int[] indices) {
        int pos = x.length / 2;
        if (x.length % 2 == 1) {
            return x[indices[pos]];
        }
        return (x[indices[pos - 1]] + x[indices[pos]]) / 2.0;
    }

    public static double meanSquaredError(double[] x, double trueValue) {
        if (x == null || x.length == 0) {
            throw new IllegalArgumentException();
        }
        double total = 0.0;
        for (double sample : x) {
            total += (sample - trueValue) * (sample - trueValue);
        }
        return total /= (double)x.length;
    }

    public static double median(double[] x) {
        if (x == null || x.length == 0) {
            throw new IllegalArgumentException();
        }
        int[] indices = new int[x.length];
        HeapSort.sort(x, indices);
        return DiscreteStatistics.median(x, indices);
    }

    public static double variance(double[] x, double mean) {
        double var = 0.0;
        int count = x.length;
        for (double aX : x) {
            if (Double.isNaN(aX)) {
                --count;
                continue;
            }
            double diff = aX - mean;
            var += diff * diff;
        }
        count = count < 2 ? 1 : --count;
        return var / (double)count;
    }

    public static double covariance(double[] x, double[] y) {
        return DiscreteStatistics.covariance(x, y, DiscreteStatistics.mean(x), DiscreteStatistics.mean(y), DiscreteStatistics.stdev(x), DiscreteStatistics.stdev(y));
    }

    public static double covariance(double[] x, double[] y, double xmean, double ymean, double xstdev, double ystdev) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y arrays must be same length!");
        }
        int count = x.length;
        double covar = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i])) {
                --count;
                continue;
            }
            covar += (x[i] - xmean) * (y[i] - ymean);
        }
        covar /= (double)count;
        return covar /= xstdev * ystdev;
    }

    public static double skewness(double[] x) {
        double mean = DiscreteStatistics.mean(x);
        double stdev = DiscreteStatistics.stdev(x);
        double skew = 0.0;
        double len = x.length;
        for (double xv : x) {
            double diff = xv - mean;
            skew += (diff /= stdev) * diff * diff;
        }
        return skew *= len / ((len - 1.0) * (len - 2.0));
    }

    public static double stdev(double[] x) {
        return Math.sqrt(DiscreteStatistics.variance(x));
    }

    public static double variance(double[] x) {
        double m = DiscreteStatistics.mean(x);
        return DiscreteStatistics.variance(x, m);
    }

    public static double varianceSampleMean(double[] x, double mean) {
        return DiscreteStatistics.variance(x, mean) / (double)x.length;
    }

    public static double varianceSampleMean(double[] x) {
        return DiscreteStatistics.variance(x) / (double)x.length;
    }

    public static double quantile(double q, double[] x, int[] indices) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("Quantile out of range");
        }
        if (q == 0.0) {
            return x[indices[0]] - 1.0;
        }
        return x[indices[(int)Math.ceil(q * (double)indices.length) - 1]];
    }

    public static double quantile(double q, double[] x) {
        int[] indices = new int[x.length];
        HeapSort.sort(x, indices);
        return DiscreteStatistics.quantile(q, x, indices);
    }

    public static double quantile(double q, double[] x, int count) {
        int[] indices = new int[count];
        HeapSort.sort(x, indices);
        return DiscreteStatistics.quantile(q, x, indices);
    }

    public static double[] HPDInterval(double proportion, double[] x, int[] indices) {
        double minRange = Double.MAX_VALUE;
        int hpdIndex = 0;
        int diff = (int)Math.round(proportion * (double)x.length);
        for (int i = 0; i <= x.length - diff; ++i) {
            double maxValue = x[indices[i + diff - 1]];
            double minValue = x[indices[i]];
            double range = Math.abs(maxValue - minValue);
            if (!(range < minRange)) continue;
            minRange = range;
            hpdIndex = i;
        }
        return new double[]{x[indices[hpdIndex]], x[indices[hpdIndex + diff - 1]]};
    }

    public static double cdf(double z, double[] x, int[] indices) {
        int i;
        for (i = 0; i < x.length && !(x[indices[i]] > z); ++i) {
        }
        return (double)i / (double)x.length;
    }

    public static double cdf(double z, double[] x) {
        int[] indices = new int[x.length];
        HeapSort.sort(x, indices);
        return DiscreteStatistics.cdf(z, x, indices);
    }

    public static double max(double[] x) {
        double max = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] > max)) continue;
            max = x[i];
        }
        return max;
    }

    public static double min(double[] x) {
        double min = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] < min)) continue;
            min = x[i];
        }
        return min;
    }

    public static double geometricMean(double[] x) {
        double gm = 0.0;
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            gm += Math.log(x[i]);
        }
        return Math.exp(gm / (double)len);
    }
}

