/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public interface DataTable<T> {
    public int getColumnCount();

    public int getRowCount();

    public String[] getColumnLabels();

    public String[] getRowLabels();

    public T getColumn(int var1);

    public T getRow(int var1);

    public T[] getData();

    public static class Text
    implements DataTable<String[]> {
        private String[] columnLabels;
        private String[] rowLabels;
        private String[][] data;

        private Text(Reader source, boolean hasColumnLabels, boolean hasRowLabels) throws IOException {
            BufferedReader reader = new BufferedReader(source);
            String line = reader.readLine();
            if (line == null) {
                throw new IllegalArgumentException("Empty file");
            }
            int columnCount = -1;
            if (hasColumnLabels) {
                ArrayList<String> columnLabels = new ArrayList<String>();
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                if (hasRowLabels && !line.startsWith("\t")) {
                    String string = tokenizer.nextToken();
                }
                while (tokenizer.hasMoreTokens()) {
                    String label = tokenizer.nextToken();
                    columnLabels.add(label);
                }
                this.columnLabels = new String[columnLabels.size()];
                columnLabels.toArray(this.columnLabels);
                columnCount = columnLabels.size();
                line = reader.readLine();
            }
            ArrayList<String> rowLabels = new ArrayList<String>();
            ArrayList<String[]> rows = new ArrayList<String[]>();
            int rowIndex = 1;
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                if (columnCount == -1) {
                    columnCount = tokenizer.countTokens();
                    if (hasRowLabels) {
                        --columnCount;
                    }
                }
                if (hasRowLabels) {
                    String label = tokenizer.nextToken();
                    rowLabels.add(label);
                }
                String[] row = new String[columnCount];
                int columnIndex = 0;
                while (tokenizer.hasMoreTokens()) {
                    row[columnIndex] = tokenizer.nextToken().trim();
                    ++columnIndex;
                }
                if (columnIndex != columnCount) {
                    throw new IllegalArgumentException("Wrong number of values on row " + (rowIndex + 1) + ", expecting " + columnCount + " but actually " + columnIndex);
                }
                rows.add(row);
                line = reader.readLine();
                ++rowIndex;
            }
            if (hasRowLabels) {
                this.rowLabels = new String[rowLabels.size()];
                rowLabels.toArray(this.rowLabels);
            }
            this.data = new String[rows.size()][];
            rows.toArray((T[])this.data);
        }

        @Override
        public int getColumnCount() {
            return this.data[0].length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String[] getColumnLabels() {
            return this.columnLabels;
        }

        @Override
        public String[] getRowLabels() {
            return this.rowLabels;
        }

        @Override
        public String[] getColumn(int columnIndex) {
            String[] column = new String[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                column[i] = this.data[i][columnIndex];
            }
            return column;
        }

        @Override
        public String[] getRow(int rowIndex) {
            return this.data[rowIndex];
        }

        public String[][] getData() {
            return this.data;
        }

        public static DataTable<String[]> parse(Reader source) throws IOException {
            return new Text(source, true, true);
        }

        public static DataTable<String[]> parse(Reader source, boolean columnLabels, boolean rowLabels) throws IOException {
            return new Text(source, columnLabels, rowLabels);
        }
    }

    public static class Double
    implements DataTable<double[]> {
        private String[] columnLabels;
        private String[] rowLabels;
        private double[][] data;

        private Double(Reader source, boolean hasColumnLabels, boolean hasRowLabels) throws IOException {
            BufferedReader reader = new BufferedReader(source);
            String line = reader.readLine();
            if (line == null) {
                throw new IllegalArgumentException("Empty file");
            }
            int columnCount = -1;
            if (hasColumnLabels) {
                ArrayList<String> columnLabels = new ArrayList<String>();
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                if (hasRowLabels && !line.startsWith("\t")) {
                    String string = tokenizer.nextToken();
                }
                while (tokenizer.hasMoreTokens()) {
                    String label = tokenizer.nextToken();
                    columnLabels.add(label);
                }
                this.columnLabels = new String[columnLabels.size()];
                columnLabels.toArray(this.columnLabels);
                columnCount = columnLabels.size();
                line = reader.readLine();
            }
            ArrayList<String> rowLabels = new ArrayList<String>();
            ArrayList<double[]> rows = new ArrayList<double[]>();
            int rowIndex = 1;
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                if (columnCount == -1) {
                    columnCount = tokenizer.countTokens();
                    if (hasRowLabels) {
                        --columnCount;
                    }
                }
                if (hasRowLabels) {
                    String label = tokenizer.nextToken();
                    rowLabels.add(label);
                }
                double[] row = new double[columnCount];
                int columnIndex = 0;
                while (tokenizer.hasMoreTokens()) {
                    String value = tokenizer.nextToken();
                    try {
                        row[columnIndex] = java.lang.Double.valueOf(value);
                    }
                    catch (NumberFormatException nfe) {
                        row[columnIndex] = java.lang.Double.NaN;
                    }
                    ++columnIndex;
                }
                if (columnIndex != columnCount) {
                    throw new IllegalArgumentException("Wrong number of values on row " + (rowIndex + 1) + ", expecting " + columnCount + " but actually " + columnIndex);
                }
                rows.add(row);
                line = reader.readLine();
                ++rowIndex;
            }
            if (hasRowLabels) {
                this.rowLabels = new String[rowLabels.size()];
                rowLabels.toArray(this.rowLabels);
            }
            this.data = new double[rows.size()][];
            rows.toArray((T[])this.data);
        }

        @Override
        public int getColumnCount() {
            return this.columnLabels.length;
        }

        @Override
        public int getRowCount() {
            return this.rowLabels.length;
        }

        @Override
        public String[] getColumnLabels() {
            return this.columnLabels;
        }

        @Override
        public String[] getRowLabels() {
            return this.rowLabels;
        }

        @Override
        public double[] getColumn(int columnIndex) {
            double[] column = new double[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                column[i] = this.data[i][columnIndex];
            }
            return column;
        }

        @Override
        public double[] getRow(int rowIndex) {
            return this.data[rowIndex];
        }

        public double[][] getData() {
            return this.data;
        }

        public static DataTable<double[]> parse(Reader source) throws IOException {
            return new Double(source, true, true);
        }

        public static DataTable<double[]> parse(Reader source, boolean columnLabels, boolean rowLabels) throws IOException {
            return new Double(source, columnLabels, rowLabels);
        }
    }
}

