/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class ErrorLogHandler
extends StreamHandler {
    private final int maxErrorCount;
    private int errorCount = 0;

    public ErrorLogHandler(int maxErrorCount) {
        this.setOutputStream(System.err);
        this.setFormatter(new MessageLogFormatter());
        this.maxErrorCount = maxErrorCount;
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
        if (record.getLevel() == Level.SEVERE) {
            ++this.errorCount;
            if (this.errorCount > this.maxErrorCount) {
                if (this.errorCount > 1) {
                    throw new RuntimeException("ErrorLog: Maximum number of errors (" + (this.maxErrorCount + 1) + ") reached. Terminating BEAST");
                }
                throw new RuntimeException("An error was encounted. Terminating BEAST");
            }
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    private class MessageLogFormatter
    extends Formatter {
        private final String lineSeparator = System.getProperty("line.separator");

        private MessageLogFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            StringBuffer sb = new StringBuffer();
            String message = this.formatMessage(record);
            sb.append(message);
            sb.append(this.lineSeparator);
            return sb.toString();
        }
    }
}

