/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;

public class FrequencySet<T> {
    private List<Bin> list = new ArrayList<Bin>();
    private Hashtable<String, Bin> hash = new Hashtable();
    private HashSet set = new HashSet();
    private boolean sorted = false;
    private int size = 0;
    private Comparator<Bin> frequencyComparator = new Comparator<Bin>(){

        @Override
        public int compare(Bin bin1, Bin bin2) {
            return bin2.frequency - bin1.frequency;
        }
    };

    public int size() {
        return this.size;
    }

    public T get(int i) {
        if (!this.sorted) {
            this.sortByFrequency();
        }
        return this.list.get((int)i).object;
    }

    protected Integer getFrequency(Object b) {
        Bin bin = this.hash.get(b.toString());
        if (bin == null) {
            return null;
        }
        return bin.frequency;
    }

    public int getFrequency(int i) {
        if (!this.sorted) {
            this.sortByFrequency();
        }
        return this.list.get((int)i).frequency;
    }

    public int getSumFrequency() {
        int sum = 0;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            sum += this.getFrequency(i);
        }
        return sum;
    }

    public void add(T object) {
        this.add(object, 1);
    }

    public void add(T object, int frequency) {
        Bin bin = this.hash.get(object.toString());
        if (bin != null) {
            ++bin.frequency;
        } else {
            bin = new Bin(object, frequency);
            this.hash.put(object.toString(), bin);
            ++this.size;
            this.sorted = false;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof FrequencySet && this.set.equals(((FrequencySet)obj).set);
    }

    private void sortByFrequency() {
        this.list.clear();
        for (Bin bin : this.hash.values()) {
            this.list.add(bin);
        }
        Collections.sort(this.list, this.frequencyComparator);
        this.sorted = true;
    }

    private class Bin {
        T object;
        int frequency;

        public Bin(T object, int frequency) {
            this.object = object;
            this.frequency = frequency;
        }

        public boolean equals(Object obj) {
            return this.object.equals(((Bin)obj).object);
        }

        public int hashCode() {
            return this.object.hashCode();
        }
    }
}

