/*
 * Decompiled with CFR 0.152.
 */
package emc;

import emc.EMCNode;
import emc.EMCParticle;
import emc.Genealogy;
import emc.SimulateEMC;
import emc.StochasticMaps;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import nuts.util.CollUtils;
import nuts.util.Counter;
import pty.smc.ParticleKernel;

public class VirtualGenealogy<S>
implements Genealogy<S> {
    private List<EMCParticle<S>> genealogy = CollUtils.list();
    private ParticleKernel<S> kernel;
    private StochasticMaps maps;
    private int K;
    private int max;
    private int nodeId;

    public VirtualGenealogy(int nodeId, int K, int max, ParticleKernel<S> kernel, StochasticMaps maps) {
        this.K = K;
        this.max = max;
        this.nodeId = nodeId;
        this.kernel = kernel;
        this.maps = maps;
        this.init();
    }

    private void init() {
        EMCParticle<S> root = new EMCParticle<S>(this.nodeId, -1L, 0L, this.K, this.max);
        root.setSample(this.kernel.getInitial(), 0.0);
        for (int k = 0; k < this.max; ++k) {
            EMCParticle<S> particle = new EMCParticle<S>(this.nodeId, 0L, k, this.K, this.max);
            particle.setParent(root);
            this.genealogy.add(k, particle);
        }
    }

    @Override
    public List<Double> generateSamples(long r) {
        EMCNode.Loginfo("Generating samples for virtual node " + this.nodeId);
        for (EMCParticle<S> particle : this.genealogy) {
            long id = particle.getId();
            particle.setSeed(this.maps.getSamplingSeed(id));
        }
        EMCNode.Loginfo("The last particle ID=" + this.genealogy.get(this.genealogy.size() - 1).getId());
        EMCNode.Loginfo("Virtual node " + this.nodeId + " generated samples for " + this.genealogy.size() + " particles.");
        return null;
    }

    @Override
    public S reconstruct(EMCParticle<S> p) {
        return null;
    }

    @Override
    public int getCapacity() {
        return this.max - this.genealogy.size();
    }

    @Override
    public List<EMCParticle<S>> resample(long r, Random resampler, List<Double> weights, double localSum, int n) {
        EMCNode.Loginfo("Begin virtual resampling... This node resamples " + n + " items.");
        if (n == 0) {
            this.genealogy.clear();
            EMCNode.Loginfo("genealogy size=" + this.genealogy.size());
            return CollUtils.list();
        }
        EMCNode.Loginfo("localSum=" + localSum);
        ArrayList<Double> ww = CollUtils.list();
        for (int i = 0; i < weights.size(); ++i) {
            ww.add(new Double(weights.get(i) / localSum));
        }
        Counter<Integer> counts = Sampling.efficientMultinomialSampling(resampler, ww, n);
        if (SimulateEMC.scheme == SimulateEMC.Allocation.Chaos) {
            ArrayList<EMCParticle<S>> resampledParticles = CollUtils.list();
            for (Integer id : counts) {
                int numResampled = (int)counts.getCount(id);
                for (int j = 0; j < numResampled; ++j) {
                    resampledParticles.add(this.genealogy.get(id));
                }
            }
            this.genealogy.clear();
            if (n != resampledParticles.size()) {
                throw new RuntimeException();
            }
            return resampledParticles;
        }
        ArrayList<EMCParticle> resampledParticles = CollUtils.list();
        for (Integer id : counts) {
            int numResampled = (int)counts.getCount(id);
            if (numResampled <= 0) continue;
            EMCParticle<S> particle = this.genealogy.get(id);
            for (int j = 0; j < numResampled; ++j) {
                resampledParticles.add(particle);
            }
        }
        this.genealogy.clear();
        ArrayList<EMCParticle<S>> rejectedParticles = CollUtils.list();
        int index = 0;
        for (int rejectionCount = Math.max(n - this.max, 0); rejectionCount > 0; --rejectionCount) {
            index = resampler.nextInt(resampledParticles.size());
            rejectedParticles.add((EMCParticle<S>)resampledParticles.remove(index));
        }
        for (EMCParticle particle : resampledParticles) {
            this.allocate(particle, r);
        }
        return rejectedParticles;
    }

    @Override
    public void allocate(List<EMCParticle<S>> rejected, long r) {
        EMCNode.Loginfo(this.nodeId + " attempt to allocate rejected particles");
        if (this.genealogy.size() >= this.max) {
            EMCNode.Loginfo("this node reached the capacity: " + this.genealogy.size());
            return;
        }
        EMCNode.Loginfo("Room=" + (this.max - this.genealogy.size()));
        while (rejected.size() > 0 && this.max - this.genealogy.size() > 0) {
            int numResampled;
            EMCParticle<S> p = rejected.remove(rejected.size() - 1);
            EMCNode.Loginfo(p.getId() + " resampled=" + numResampled);
            for (numResampled = p.getNumResampled(); this.genealogy.size() < this.max && numResampled > 0; --numResampled) {
                EMCParticle<S> newParticle = new EMCParticle<S>(this.nodeId, r + 1L, this.genealogy.size(), this.K, this.max);
                newParticle.setParent(p);
                this.genealogy.add(newParticle);
            }
            if (numResampled <= 0) continue;
            p.setNumResampled(numResampled);
            rejected.add(p);
        }
    }

    @Override
    public boolean allocate(EMCParticle<S> particle, long r) {
        if (this.max - this.genealogy.size() <= 0) {
            return false;
        }
        EMCParticle<S> newParticle = new EMCParticle<S>(this.nodeId, r + 1L, this.genealogy.size(), this.K, this.max);
        newParticle.setParent(particle);
        this.genealogy.add(newParticle);
        return true;
    }

    @Override
    public long getGenerations() {
        throw new RuntimeException("Virtual genealogy don't have to know the number of iterations left.");
    }

    @Override
    public void processParticles() {
    }
}

