/*
 * Decompiled with CFR 0.152.
 */
package ev.multi;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Parallelizer;
import fig.exec.Execution;
import goblin.CognateId;
import goblin.Taxon;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ma.BioCorpus;
import ma.MSAPoset;
import nuts.io.CSV;
import nuts.util.CollUtils;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import pty.RootedTree;

public class IncrementalAlignExperiment
implements Runnable {
    private Map<CognateId, IncrementalAligner> aligners;
    private List<CognateId> ids;
    private List<GuessType> guessTypes;
    private Map<CognateId, MSAPoset> references;
    @Option
    public int maxNumberOfAligns = Integer.MAX_VALUE;
    @Option
    public int nThreads = 1;
    @Option
    public int nIterations = 1000;
    @Option
    public int evaluationPeriod = 1;

    public void init(BioCorpus bc, IncrementalAlignerFactory factory) {
        this.ids = CollUtils.list(bc.intersectedIds());
        if (this.ids.size() > this.maxNumberOfAligns) {
            this.ids = this.ids.subList(0, this.maxNumberOfAligns);
        }
        this.guessTypes = CollUtils.list(factory.supportedGuessTypes());
        this.references = CollUtils.map();
        for (CognateId id : this.ids) {
            this.references.put(id, bc.getMSAPoset(id));
        }
        this.aligners = CollUtils.map();
        File detailedOutput = new File(Execution.getFile("detailed-output"));
        detailedOutput.mkdir();
        for (CognateId id : this.ids) {
            File dir = new File(detailedOutput, IncrementalAlignExperiment.normalizeId(id));
            dir.mkdir();
            this.aligners.put(id, factory.createNewAligner(bc.getMultiAlignment(id).getSequences(), RootedTree.Util.fromBalibase(bc, id), dir));
        }
    }

    public static String normalizeId(CognateId id) {
        return id.toString().replaceAll("[/]", "-");
    }

    @Override
    public void run() {
        File alignmentDirs = new File(Execution.getFile("alignments"));
        alignmentDirs.mkdir();
        File evaluationDetailsDir = new File(Execution.getFile("detailed-evaluations"));
        evaluationDetailsDir.mkdir();
        for (int iter = 0; iter < this.nIterations; ++iter) {
            final int _iter = iter;
            LogInfo.track("Iteration " + iter + "/" + this.nIterations);
            Parallelizer<CognateId> parallelizer = new Parallelizer<CognateId>(this.nThreads);
            parallelizer.setPrimaryThread();
            parallelizer.process(this.ids, new Parallelizer.Processor<CognateId>(){

                @Override
                public void process(CognateId id, int _i, int _n, boolean log) {
                    try {
                        if (log) {
                            LogInfo.logs("Processing " + id + " (" + _i + "/" + _n + ")");
                        }
                        ((IncrementalAligner)IncrementalAlignExperiment.this.aligners.get(id)).iterate(_iter, IncrementalAlignExperiment.this.nIterations);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LogInfo.error(e);
                    }
                }
            });
            LogInfo.end_track();
            if (iter % this.evaluationPeriod != 0) continue;
            LogInfo.track("Evaluation");
            final HashMap alignPaths = CollUtils.map();
            for (GuessType type : this.guessTypes) {
                File cur = new File(alignmentDirs, "iteration-" + iter + "-" + (Object)((Object)type));
                cur.mkdir();
                alignPaths.put(type, cur);
            }
            final HashMap[] results = new HashMap[this.ids.size()];
            final HashMap[] resultsPrecision = new HashMap[this.ids.size()];
            Parallelizer<Integer> parallelizer2 = new Parallelizer<Integer>(this.nThreads);
            parallelizer2.setPrimaryThread();
            parallelizer2.process(CollUtils.ints(this.ids.size()), new Parallelizer.Processor<Integer>(){

                @Override
                public void process(Integer i, int _i, int _n, boolean log) {
                    HashMap current = CollUtils.map();
                    HashMap currentPrecision = CollUtils.map();
                    CognateId id = (CognateId)IncrementalAlignExperiment.this.ids.get(i);
                    if (log) {
                        LogInfo.logs("Processing " + id + " (" + _i + "/" + _n + ")");
                    }
                    IncrementalAligner aligner = (IncrementalAligner)IncrementalAlignExperiment.this.aligners.get(id);
                    results[i.intValue()] = current;
                    resultsPrecision[i.intValue()] = currentPrecision;
                    for (GuessType guessType : IncrementalAlignExperiment.this.guessTypes) {
                        try {
                            MSAPoset ma = aligner.currentGuess(guessType);
                            double sumOfPairs = MSAPoset.edgeRecall((MSAPoset)IncrementalAlignExperiment.this.references.get(id), ma);
                            double precision = MSAPoset.edgePrecision((MSAPoset)IncrementalAlignExperiment.this.references.get(id), ma);
                            current.put(guessType, sumOfPairs);
                            currentPrecision.put(guessType, precision);
                            File curFile = new File((File)alignPaths.get((Object)guessType), "" + IncrementalAlignExperiment.normalizeId(id) + ".msf");
                            PrintWriter out = IOUtils.openOutHard(curFile);
                            out.append(ma.toMultiAlignmentObject().toMSFString());
                            out.close();
                        }
                        catch (Exception e) {
                            LogInfo.error(e);
                            current.put(guessType, null);
                            currentPrecision.put(guessType, null);
                        }
                    }
                }
            });
            LogInfo.end_track();
            HashMap stat = CollUtils.map();
            HashMap statPrecision = CollUtils.map();
            for (GuessType guessType : this.guessTypes) {
                stat.put(guessType, new SummaryStatistics());
                statPrecision.put(guessType, new SummaryStatistics());
            }
            File outFile = new File(evaluationDetailsDir, "iter-" + iter + ".txt");
            PrintWriter out = IOUtils.openOutHard(outFile);
            out.println(CSV.body("#iter", "file", "guess-type", "recall", "precision", "note"));
            for (int i = 0; i < results.length; ++i) {
                CognateId id = this.ids.get(i);
                for (GuessType type : this.guessTypes) {
                    Double current = (Double)results[i].get((Object)type);
                    Double currentPrecision = (Double)resultsPrecision[i].get((Object)type);
                    String note = "";
                    if (current == null || currentPrecision == null) {
                        current = 0.0;
                        currentPrecision = 0.0;
                        note = "crashed";
                    }
                    ((SummaryStatistics)stat.get((Object)type)).addValue(current.doubleValue());
                    ((SummaryStatistics)statPrecision.get((Object)type)).addValue(currentPrecision.doubleValue());
                    out.println(CSV.body(new Object[]{iter, id, type, current, currentPrecision, note}));
                }
            }
            for (GuessType type : this.guessTypes) {
                LogInfo.logsForce("Average recall/precision for " + (Object)((Object)type) + ":" + ((SummaryStatistics)stat.get((Object)type)).getMean() + "/" + ((SummaryStatistics)statPrecision.get((Object)type)).getMean());
                out.println(CSV.body(new Object[]{iter, "AVERAGE", type, ((SummaryStatistics)stat.get((Object)type)).getMean(), ((SummaryStatistics)statPrecision.get((Object)type)).getMean(), ""}));
            }
            out.close();
        }
    }

    public static interface IncrementalAlignerFactory {
        public Set<GuessType> supportedGuessTypes();

        public IncrementalAligner createNewAligner(Map<Taxon, String> var1, RootedTree var2, File var3);
    }

    public static enum GuessType {
        SAMPLE,
        MAX_RECALL_MBR,
        HALF_MBR;

    }

    public static interface IncrementalAligner {
        public void iterate(int var1, int var2);

        public MSAPoset currentGuess(GuessType var1);
    }
}

