/*
 * Decompiled with CFR 0.152.
 */
package ev.poi;

import conifer.msa.TreeMSAParameters;
import conifer.pip.LinearizedAlignment;
import conifer.pip.PIPLikelihoodCalculator;
import ev.poi.QuasiStationaryProcessUtils;
import java.util.Random;
import ma.RateMatrixLoader;
import nuts.math.MtxUtils;
import nuts.math.RateMtxUtils;
import nuts.util.Indexer;
import nuts.util.MathUtils;
import org.junit.Assert;
import org.junit.Test;
import pepper.Encodings;
import pty.RootedTree;

public class PoissonParameters
implements TreeMSAParameters {
    public final double[][] subRateMtx;
    public final double insertRate;
    public final double deleteRate;
    public final int numberOfCharacter;
    public final int numberOfCharacterPlusGap;
    public final int gapIndex;
    public final double[][] Q;
    public final Indexer<Character> indexer;
    public final double[] quasiStatLogProbabilities;
    public final double[] quasiStatProbs;
    public static char star = (char)42;

    public static PoissonParameters copyWithNewInsertRate(PoissonParameters model, double insertRate) {
        return new PoissonParameters(model.indexer, model.subRateMtx, insertRate, model.deleteRate);
    }

    public static PoissonParameters copyWithNewDeleteRate(PoissonParameters model, double deleteRate) {
        return new PoissonParameters(model.indexer, model.subRateMtx, model.insertRate, deleteRate);
    }

    public static PoissonParameters copyWithNewInsertDeleteRate(PoissonParameters model, double insertRate, double deleteRate) {
        return new PoissonParameters(model.indexer, model.subRateMtx, insertRate, deleteRate);
    }

    @Deprecated
    public static double getDeleteRate(double expectedLen, double intensity) {
        return Math.sqrt(intensity / expectedLen);
    }

    @Deprecated
    public static double getInsertionRate(double expectedLen, double intensity) {
        return expectedLen * PoissonParameters.getDeleteRate(expectedLen, intensity);
    }

    @Deprecated
    public static double getAsymptoticLengthParameter(double lambda, double mu) {
        return lambda / mu;
    }

    @Deprecated
    public static double getIndelIntensityParameter(double lambda, double mu) {
        return lambda * mu;
    }

    public static double getDeleteRateFromAdditiveIntensityParam(double expectedLen, double intensity) {
        return intensity / expectedLen / 2.0;
    }

    public static double getInsertionRateFromAdditiveIntensityParam(double expectedLen, double intensity) {
        return intensity / 2.0;
    }

    public static double getAsymptoticLengthParameterForAdditiveIntensityParam(double lambda, double mu) {
        return lambda / mu;
    }

    public static double getIndelIntensityParameterForAdditiveIntensityParam(double lambda, double mu) {
        return 2.0 * lambda;
    }

    public static PoissonParameters rnaParams(double insRate, double delRate) {
        return new PoissonParameters(Encodings.rnaEncodings().nonGapCharactersIndexer(), RateMatrixLoader.k2p(), insRate, delRate);
    }

    public static PoissonParameters createFromAdditiveLengthIntensityParameterization(Indexer<Character> indexer, double[][] subRateMtx, double asymptoticLen, double additiveIndelIntensity) {
        double insertRate = PoissonParameters.getInsertionRateFromAdditiveIntensityParam(asymptoticLen, additiveIndelIntensity);
        double delRate = PoissonParameters.getDeleteRateFromAdditiveIntensityParam(asymptoticLen, additiveIndelIntensity);
        return new PoissonParameters(indexer, subRateMtx, insertRate, delRate);
    }

    public PoissonParameters(Indexer<Character> indexer, double[][] subRateMtx, double insertRate, double deletionRate) {
        if (insertRate <= 0.0 || deletionRate <= 0.0) {
            throw new RuntimeException();
        }
        if (indexer.size() != subRateMtx.length) {
            throw new RuntimeException();
        }
        if (subRateMtx.length != subRateMtx[0].length) {
            throw new RuntimeException();
        }
        this.indexer = indexer;
        this.insertRate = insertRate;
        this.deleteRate = deletionRate;
        this.subRateMtx = subRateMtx;
        this.numberOfCharacter = subRateMtx.length;
        this.numberOfCharacterPlusGap = this.numberOfCharacter + 1;
        this.gapIndex = this.numberOfCharacter;
        double[] deleteRates = PoissonParameters.uniformDeletionRate(deletionRate, this.numberOfCharacter);
        this.Q = QuasiStationaryProcessUtils.formQMtx(subRateMtx, deleteRates);
        RateMtxUtils.checkRateMtx(this.Q);
        this.quasiStatLogProbabilities = QuasiStationaryProcessUtils.quasiStationaryDistributionFromRates(subRateMtx, deleteRates);
        this.quasiStatProbs = (double[])this.quasiStatLogProbabilities.clone();
        MtxUtils.logInPlace(this.quasiStatLogProbabilities);
    }

    private static double[] uniformDeletionRate(double deletionRate, int nChars) {
        double[] result = new double[nChars];
        for (int i = 0; i < nChars; ++i) {
            result[i] = deletionRate;
        }
        return result;
    }

    public static PoissonParameters simplePIP(double lambda, double mu) {
        double[][] trivialRateMtx = new double[][]{{1.0}};
        Indexer<Character> trivialIndex = new Indexer<Character>();
        trivialIndex.addToIndex(Character.valueOf(star));
        return new PoissonParameters(trivialIndex, trivialRateMtx, lambda, mu);
    }

    public static String repeat(char star, int nRep) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nRep; ++i) {
            result.append(star);
        }
        return result.toString();
    }

    @Override
    public double getLogLikelihood(LinearizedAlignment linearizedAlignment, RootedTree tree) {
        PIPLikelihoodCalculator calculator = new PIPLikelihoodCalculator(this, linearizedAlignment, tree);
        return calculator.computeDataLogProbabilityGivenTree();
    }

    public static class Tests {
        @Test
        public void testReparam() {
            Random rand = new Random(1L);
            for (int i = 0; i < 10; ++i) {
                double mu = 10.0 * rand.nextDouble();
                double lambda = 10.0 * rand.nextDouble();
                double len = PoissonParameters.getAsymptoticLengthParameter(lambda, mu);
                double inte = PoissonParameters.getIndelIntensityParameter(lambda, mu);
                Assert.assertEquals((double)mu, (double)PoissonParameters.getDeleteRate(len, inte), (double)MathUtils.threshold);
                Assert.assertEquals((double)lambda, (double)PoissonParameters.getInsertionRate(len, inte), (double)MathUtils.threshold);
            }
        }

        @Test
        public void testReparam2() {
            Random rand = new Random(1L);
            for (int i = 0; i < 10; ++i) {
                double mu = 1.0;
                double lambda = 2.0;
                double len = PoissonParameters.getAsymptoticLengthParameterForAdditiveIntensityParam(lambda, mu);
                double inte = PoissonParameters.getIndelIntensityParameterForAdditiveIntensityParam(lambda, mu);
                double mu2 = PoissonParameters.getDeleteRateFromAdditiveIntensityParam(len, inte);
                double l2 = PoissonParameters.getInsertionRateFromAdditiveIntensityParam(len, inte);
                double len2 = PoissonParameters.getAsymptoticLengthParameterForAdditiveIntensityParam(l2, mu2);
                double inte2 = PoissonParameters.getIndelIntensityParameterForAdditiveIntensityParam(l2, mu2);
                Assert.assertEquals((double)mu, (double)mu2, (double)MathUtils.threshold);
                Assert.assertEquals((double)lambda, (double)l2, (double)MathUtils.threshold);
            }
        }
    }
}

