/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor;

import fenchel.factor.BinaryFactor;
import fenchel.factor.FactorGraph;
import fenchel.factor.IdentityFactor;
import fenchel.factor.UnaryFactor;
import fig.basic.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nuts.math.Graph;
import nuts.math.MutableGraph;

public class SimpleFactorGraph<N>
implements FactorGraph<N> {
    private Map<N, UnaryFactor> unaries = new HashMap<N, UnaryFactor>();
    private Map<Pair<N, N>, BinaryFactor> binaries = new HashMap<Pair<N, N>, BinaryFactor>();
    private MutableGraph<N> graph = new MutableGraph();

    @Override
    public UnaryFactor getUnary(N node) {
        UnaryFactor result = this.unaries.get(node);
        if (result == null) {
            if (!this.graph.vertexSet().contains(node)) {
                throw new RuntimeException();
            }
            result = IdentityFactor.identity;
        }
        return result;
    }

    @Override
    public BinaryFactor getBinary(N source, N destination) {
        return this.binaries.get(Pair.makePair(source, destination));
    }

    public void addUnary(N node, UnaryFactor f) {
        UnaryFactor current = this.unaries.get(node);
        if (current == null) {
            current = f;
            this.graph.addVertex(node);
        } else {
            current = current.multiply(Collections.singletonList(f));
        }
        this.unaries.put(node, current);
    }

    public void addBinary(N firstEndPt, N secondEndPt, BinaryFactor b) {
        Pair<N, N> key = Pair.makePair(firstEndPt, secondEndPt);
        if (this.binaries.containsKey(key)) {
            throw new RuntimeException();
        }
        this.graph.addEdge(firstEndPt, secondEndPt);
        this.binaries.put(key, b);
    }

    @Override
    public Graph<N> getTopology() {
        return this.graph;
    }

    public String toString() {
        return this.graph.toString();
    }
}

