/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor.multisites;

import fenchel.factor.BinaryFactor;
import fenchel.factor.FactorGraph;
import fenchel.factor.FactorUtils;
import fenchel.factor.UnaryFactor;
import fenchel.factor.multisites.MSFactorGraph;
import fenchel.factor.multisites.MSUnaryMap;
import fenchel.factor.multisites.MSUnaryScaledFactor;
import nuts.math.Graph;

public class SubFactorGraph<N>
implements FactorGraph<N> {
    private final MSFactorGraph<N> baseGraph;
    private final Graph<N> subgraph;
    private final MSUnaryMap<N> unaries;

    public SubFactorGraph(MSFactorGraph<N> baseGraph, Graph<N> subgraph, MSUnaryMap<N> unaries) {
        this.baseGraph = baseGraph;
        this.subgraph = subgraph;
        this.unaries = unaries;
    }

    @Override
    public UnaryFactor getUnary(N node) {
        if (!this.subgraph.vertexSet().contains(node)) {
            throw new RuntimeException();
        }
        double[][] values = this.unaries.getUnaryArray(node);
        if (values != null) {
            return MSUnaryScaledFactor.buildFactor(values);
        }
        if (this.subgraph.nbrs(node).size() < 2) {
            this.baseGraph.ensureLeafNotIdentity(node);
        }
        return this.baseGraph.getUnary(node);
    }

    @Override
    public BinaryFactor getBinary(N source, N destination) {
        if (!this.subgraph.hasEdge(source, destination)) {
            throw new RuntimeException();
        }
        return this.baseGraph.getBinary(source, destination);
    }

    @Override
    public Graph<N> getTopology() {
        return this.subgraph;
    }

    public String toString() {
        return FactorUtils.factorGraphUnariesToString(this);
    }
}

