/*
 * Decompiled with CFR 0.152.
 */
package fenchel.old;

import fenchel.measurefacto.ExponentialFamily;
import fenchel.old.MFCalculator;
import java.util.ArrayList;
import java.util.List;
import nuts.io.IO;

public class Old_MFBeliefProp<M> {
    private MFCalculator<M> messageCalculator = null;
    private List<ExponentialFamily<M>> measureFactors = null;
    private M parameters = null;

    public void init(MFCalculator<M> messageCalculator, List<ExponentialFamily<M>> measureFactors, M parameters) {
        this.parameters = parameters;
        this.messageCalculator = messageCalculator;
        this.measureFactors = measureFactors;
    }

    public int nFactors() {
        return this.measureFactors.size();
    }

    private List<M> initXis(M parameters, int nFactors) {
        ArrayList<M> result = new ArrayList<M>();
        for (int i = 0; i < nFactors; ++i) {
            result.add(parameters);
        }
        return result;
    }

    private List<M> xis2Zetas(List<M> xis) {
        ArrayList<M> results = new ArrayList<M>(this.nFactors());
        for (int fIndex = 0; fIndex < this.nFactors(); ++fIndex) {
            M xi = xis.get(fIndex);
            M currentMoments = this.measureFactors.get(fIndex).moments(xi);
            M transformed = this.messageCalculator.oddTransform(currentMoments);
            M result = this.messageCalculator.retract(transformed, xi);
            results.add(result);
        }
        return results;
    }

    private List<M> zetas2Xis(List<M> zetas) {
        IO.warnOnce("Make a simpler version if there are two zetas");
        M aggregate = this.combineZetasWithParameters(zetas);
        ArrayList<M> result = new ArrayList<M>(this.nFactors());
        for (int fIndex = 0; fIndex < this.nFactors(); ++fIndex) {
            result.add(this.messageCalculator.retract(aggregate, zetas.get(fIndex)));
        }
        return result;
    }

    private M combineZetasWithParameters(List<M> zetas) {
        ArrayList<M> toCombine = new ArrayList<M>(this.nFactors() + 1);
        toCombine.addAll(zetas);
        toCombine.add(this.parameters);
        M aggregate = this.messageCalculator.combine(toCombine);
        return aggregate;
    }
}

