/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.exec.servlet.Field;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.FileView;
import fig.exec.servlet.Item;
import fig.exec.servlet.MapFileField;
import fig.exec.servlet.MyException;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import fig.exec.servlet.Value;
import fig.exec.servlet.View;
import java.io.File;

public class Basket
extends View<Item> {
    public Basket(Trail trail, FileSource source) {
        this.trail = trail;
        this.source = source;
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap(this.source.getFileView());
        fields.add(new Field("Count", "Number of items"));
        fields.add((Field)new MapFileField((String)"Description", (String)"One-line description", (String)"", (String)"description", (FileView)this.source.getFileView())).mutable = true;
        return fields;
    }

    @Override
    protected Value getFieldValue(String name) throws MyException {
        if (name.equals("Trail")) {
            return new Value(this.getTrail().toString());
        }
        return super.getFieldValue(name);
    }

    @Override
    public FieldListMap getItemsFields() {
        FieldListMap fields = new FieldListMap();
        fields.add(new Field("Trail", "Full trail of the item"));
        return fields;
    }

    @Override
    protected boolean useNumbering() {
        return true;
    }

    @Override
    protected File getGroundedIndexPath() {
        return this.source.getPath();
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.updateItemsFromFile(spec, this.source);
    }

    @Override
    protected String itemToSpec(Item item) throws MyException {
        return item.getTrail().toStringValue();
    }

    @Override
    protected String specToName(String spec) throws MyException {
        return new Trail(spec).getName();
    }

    @Override
    protected Item specToItem(String spec) throws MyException {
        return this.source.getDomainView().getItem(new Trail(spec));
    }
}

