/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.ListUtils;
import fig.basic.OrderedMap;
import fig.exec.servlet.AllExecView;
import fig.exec.servlet.DirSource;
import fig.exec.servlet.ExecFactory;
import fig.exec.servlet.ExecView;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.GroundedExecView;
import fig.exec.servlet.MyException;
import fig.exec.servlet.OrphanedExecView;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import fig.exec.servlet.View;
import java.io.File;

public class ExecViewDB
extends View<ExecView> {
    private static final String indexFile = "_index.index";
    public static final String allName = "(all)";
    public static final String orphanedName = "(orphaned)";
    private DirSource execsSource;
    private DirSource viewsSource;
    private AllExecView allExecView;
    private OrphanedExecView orphanedExecView;
    private ExecFactory factory;
    private OrderedMap<String, ExecView> execViews;

    public ExecViewDB(Trail trail, DirSource execsSource, DirSource viewsSource, ExecFactory factory) {
        this.trail = trail;
        this.source = viewsSource;
        this.execsSource = execsSource;
        this.viewsSource = viewsSource;
        this.factory = factory;
        this.execViews = new OrderedMap();
        this.allExecView = new AllExecView(this.childTrail(allName), execsSource, factory);
        this.orphanedExecView = new OrphanedExecView(this.childTrail(orphanedName), execsSource, factory);
        this.addItemHard(this.allExecView);
        this.addItemHard(this.orphanedExecView);
    }

    @Override
    public FieldListMap getMetadataFields() {
        return new FieldListMap();
    }

    @Override
    public FieldListMap getItemsFields() {
        return new GroundedExecView(null, this.source, null).getMetadataFields();
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.updateItemsFromFile(spec, ListUtils.newList(this.allExecView), new FileSource(this.viewsSource, indexFile), ListUtils.newList(this.orphanedExecView));
        this.updateChildren(spec, priority.next());
    }

    public File getExecsDir() {
        return this.execsSource.getPath();
    }

    @Override
    protected File getGroundedIndexPath() {
        return ((DirSource)this.source).getPath(indexFile);
    }

    @Override
    protected ExecView newItem(String name) {
        return new GroundedExecView(this.childTrail(name), new FileSource((DirSource)this.source, this.nameToFile(name)), this.factory);
    }

    @Override
    protected String itemToSpec(ExecView item) throws MyException {
        if (item == this.allExecView) {
            return null;
        }
        if (item == this.orphanedExecView) {
            return null;
        }
        return super.itemToSpec(item);
    }

    public AllExecView getAllExecView() {
        return this.allExecView;
    }

    public OrphanedExecView getOrphanedExecView() {
        return this.orphanedExecView;
    }

    private String nameToFile(String name) {
        return name + ".index";
    }
}

