/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.OrderedStringMap;
import fig.exec.servlet.Field;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FileItem;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.FileView;
import fig.exec.servlet.MapFileField;
import fig.exec.servlet.MyException;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import fig.exec.servlet.WebState;
import java.io.IOException;

public class MapFileItem
extends FileItem {
    protected OrderedStringMap map = new OrderedStringMap();

    public MapFileItem(Trail trail, FileSource source) {
        super(trail, source);
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = super.getMetadataFields();
        for (String key : this.map.keys()) {
            fields.add((Field)new MapFileField((String)key, (String)"", (String)"", (String)key, (FileView)this.source.getFileView())).mutable = true;
        }
        return fields;
    }

    public void clear() {
        this.map.clear();
    }

    public void load() throws MyException {
        try {
            this.map.read(this.source.getPath());
        }
        catch (IOException e) {
            WebState.logs("MapFileItem: loading " + this.trail + " failed");
        }
    }

    public void save() throws MyException {
        try {
            this.map.print(this.source.getPath());
        }
        catch (IOException e) {
            WebState.logs("MapFileItem: saving " + this.trail + " failed");
        }
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.load();
        super.update(spec, priority);
    }

    public String getValue(String key) {
        return (String)this.map.get(key);
    }

    public void setValue(String key, String value) throws MyException {
        this.map.reput(key, value);
        this.save();
    }

    public OrderedStringMap getMap() {
        return this.map;
    }
}

